/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.avro.io.Decoder;

public class AvroStructConsumer
implements Consumer<StructVector> {
    private final Consumer[] delegates;
    private StructVector vector;
    private int currentIndex;

    public AvroStructConsumer(StructVector vector, Consumer[] delegates) {
        this.vector = vector;
        this.delegates = delegates;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].consume(decoder);
        }
        this.vector.setIndexDefined(this.currentIndex);
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        this.vector.setValueCount(this.currentIndex);
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
        AutoCloseables.close((AutoCloseable[])this.delegates);
    }

    @Override
    public void resetValueVector(StructVector vector) {
        this.vector = vector;
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].resetValueVector((ValueVector)vector.getChildrenFromFields().get(i));
        }
        this.currentIndex = 0;
    }
}

