/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.avro.io.Decoder;

public class AvroFloatConsumer
implements Consumer<Float4Vector> {
    private Float4Vector vector;
    private int currentIndex;

    public AvroFloatConsumer(Float4Vector vector) {
        this.vector = vector;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.setSafe(this.currentIndex++, decoder.readFloat());
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(Float4Vector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

