/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.avro.io.Decoder;

public class AvroEnumConsumer
implements Consumer<BaseIntVector> {
    private BaseIntVector vector;
    private int currentIndex;

    public AvroEnumConsumer(BaseIntVector vector) {
        this.vector = vector;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.setWithPossibleTruncate(this.currentIndex++, (long)decoder.readEnum());
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(BaseIntVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

