/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.avro.io.Decoder;

public class AvroDoubleConsumer
implements Consumer<Float8Vector> {
    private Float8Vector vector;
    private int currentIndex;

    public AvroDoubleConsumer(Float8Vector vector) {
        this.vector = vector;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.setSafe(this.currentIndex++, decoder.readDouble());
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(Float8Vector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

