/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;

public class AvroToArrowConfig {
    private final BufferAllocator allocator;
    private final int targetBatchSize;
    private final DictionaryProvider.MapDictionaryProvider provider;

    public AvroToArrowConfig(BufferAllocator allocator) {
        this(allocator, 1024);
    }

    public AvroToArrowConfig(BufferAllocator allocator, int targetBatchSize) {
        this(allocator, targetBatchSize, new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]));
    }

    public AvroToArrowConfig(BufferAllocator allocator, int targetBatchSize, DictionaryProvider.MapDictionaryProvider provider) {
        Preconditions.checkArgument((targetBatchSize == -1 || targetBatchSize > 0 ? 1 : 0) != 0, (String)"invalid targetBatchSize: %s", (int)targetBatchSize);
        this.allocator = allocator;
        this.targetBatchSize = targetBatchSize;
        this.provider = provider;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public int getTargetBatchSize() {
        return this.targetBatchSize;
    }

    public DictionaryProvider.MapDictionaryProvider getProvider() {
        return this.provider;
    }
}

