/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;

public class VariableWidthOutOfPlaceVectorSorter<V extends BaseVariableWidthVector>
implements OutOfPlaceVectorSorter<V> {
    protected IndexSorter<V> indexSorter = new IndexSorter();

    @Override
    public void sortOutOfPlace(V srcVector, V dstVector, VectorValueComparator<V> comparator) {
        comparator.attachVector(srcVector);
        ArrowBuf srcValueBuffer = srcVector.getDataBuffer();
        ArrowBuf srcOffsetBuffer = srcVector.getOffsetBuffer();
        ArrowBuf dstValidityBuffer = dstVector.getValidityBuffer();
        ArrowBuf dstValueBuffer = dstVector.getDataBuffer();
        ArrowBuf dstOffsetBuffer = dstVector.getOffsetBuffer();
        Preconditions.checkArgument((dstValidityBuffer.capacity() * 8L >= (long)srcVector.getValueCount() ? 1 : 0) != 0, (String)"Not enough capacity for the validity buffer of the dst vector. Expected capacity %s, actual capacity %s", (int)((srcVector.getValueCount() + 7) / 8), (long)dstValidityBuffer.capacity());
        Preconditions.checkArgument((dstOffsetBuffer.capacity() >= (long)((srcVector.getValueCount() + 1) * 4) ? 1 : 0) != 0, (String)"Not enough capacity for the offset buffer of the dst vector. Expected capacity %s, actual capacity %s", (int)((srcVector.getValueCount() + 1) * 4), (long)dstOffsetBuffer.capacity());
        long dataSize = srcVector.getOffsetBuffer().getInt((long)(srcVector.getValueCount() * 4));
        Preconditions.checkArgument((dstValueBuffer.capacity() >= dataSize ? 1 : 0) != 0, (String)"No enough capacity for the data buffer of the dst vector. Expected capacity %s, actual capacity %s", (long)dataSize, (long)dstValueBuffer.capacity());
        try (IntVector sortedIndices = new IntVector("", srcVector.getAllocator());){
            sortedIndices.allocateNew(srcVector.getValueCount());
            sortedIndices.setValueCount(srcVector.getValueCount());
            this.indexSorter.sort(srcVector, sortedIndices, comparator);
            int dstOffset = 0;
            dstOffsetBuffer.setInt(0L, 0);
            for (int dstIndex = 0; dstIndex < sortedIndices.getValueCount(); ++dstIndex) {
                int srcIndex = sortedIndices.get(dstIndex);
                if (srcVector.isNull(srcIndex)) {
                    BitVectorHelper.unsetBit((ArrowBuf)dstValidityBuffer, (int)dstIndex);
                } else {
                    BitVectorHelper.setBit((ArrowBuf)dstValidityBuffer, (long)dstIndex);
                    int srcOffset = srcOffsetBuffer.getInt((long)(srcIndex * 4));
                    int valueLength = srcOffsetBuffer.getInt((long)((srcIndex + 1) * 4)) - srcOffset;
                    MemoryUtil.UNSAFE.copyMemory(srcValueBuffer.memoryAddress() + (long)srcOffset, dstValueBuffer.memoryAddress() + (long)dstOffset, valueLength);
                    dstOffset += valueLength;
                }
                dstOffsetBuffer.setInt((long)((dstIndex + 1) * 4), dstOffset);
            }
        }
    }
}

