/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.deduplicate;

import org.apache.arrow.algorithm.deduplicate.DeduplicationUtils;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.DataSizeRoundingUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;

public class VectorRunDeduplicator<V extends ValueVector>
implements AutoCloseable {
    private ArrowBuf distinctValueBuffer;
    private final V vector;
    private final BufferAllocator allocator;

    public VectorRunDeduplicator(V vector, BufferAllocator allocator) {
        this.vector = vector;
        this.allocator = allocator;
    }

    private void createDistinctValueBuffer() {
        Preconditions.checkArgument((this.distinctValueBuffer == null ? 1 : 0) != 0);
        int bufSize = DataSizeRoundingUtil.divideBy8Ceil((int)this.vector.getValueCount());
        this.distinctValueBuffer = this.allocator.buffer((long)bufSize);
        DeduplicationUtils.populateRunStartIndicators(this.vector, this.distinctValueBuffer);
    }

    public int getRunCount() {
        if (this.distinctValueBuffer == null) {
            this.createDistinctValueBuffer();
        }
        return this.vector.getValueCount() - BitVectorHelper.getNullCount((ArrowBuf)this.distinctValueBuffer, (int)this.vector.getValueCount());
    }

    public void populateDeduplicatedValues(V outVector) {
        if (this.distinctValueBuffer == null) {
            this.createDistinctValueBuffer();
        }
        DeduplicationUtils.populateDeduplicatedValues(this.distinctValueBuffer, this.vector, outVector);
    }

    public void populateRunLengths(IntVector lengthVector) {
        if (this.distinctValueBuffer == null) {
            this.createDistinctValueBuffer();
        }
        DeduplicationUtils.populateRunLengths(this.distinctValueBuffer, lengthVector, this.vector.getValueCount());
    }

    @Override
    public void close() {
        if (this.distinctValueBuffer != null) {
            this.distinctValueBuffer.close();
            this.distinctValueBuffer = null;
        }
    }
}

