/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.dictionary;

import org.apache.arrow.algorithm.search.VectorSearcher;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.vector.ValueVector;

public class SearchDictionaryEncoder<E extends BaseIntVector, D extends ValueVector> {
    private final D dictionary;
    private final VectorValueComparator<D> comparator;
    private final boolean encodeNull;

    public SearchDictionaryEncoder(D dictionary, VectorValueComparator<D> comparator) {
        this(dictionary, comparator, false);
    }

    public SearchDictionaryEncoder(D dictionary, VectorValueComparator<D> comparator, boolean encodeNull) {
        this.dictionary = dictionary;
        this.comparator = comparator;
        this.encodeNull = encodeNull;
    }

    public void encode(D input, E output) {
        for (int i = 0; i < input.getValueCount(); ++i) {
            if (!this.encodeNull && input.isNull(i)) continue;
            int index = VectorSearcher.binarySearch(this.dictionary, this.comparator, input, i);
            if (index == -1) {
                throw new IllegalArgumentException("The data element is not found in the dictionary: " + i);
            }
            output.setWithPossibleTruncate(i, (long)index);
        }
        output.setValueCount(input.getValueCount());
    }
}

