/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.arrow.algorithm.sort.IndexSorter;
import org.apache.arrow.algorithm.sort.OutOfPlaceVectorSorter;
import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.IntVector;

public class VariableWidthOutOfPlaceVectorSorter<V extends BaseVariableWidthVector>
implements OutOfPlaceVectorSorter<V> {
    protected IndexSorter<V> indexSorter = new IndexSorter();

    @Override
    public void sortOutOfPlace(V srcVector, V dstVector, VectorValueComparator<V> comparator) {
        comparator.attachVector(srcVector);
        ArrowBuf srcValueBuffer = srcVector.getDataBuffer();
        ArrowBuf srcOffsetBuffer = srcVector.getOffsetBuffer();
        ArrowBuf dstValidityBuffer = dstVector.getValidityBuffer();
        ArrowBuf dstValueBuffer = dstVector.getDataBuffer();
        ArrowBuf dstOffsetBuffer = dstVector.getOffsetBuffer();
        try (IntVector sortedIndices = new IntVector("", srcVector.getAllocator());){
            sortedIndices.allocateNew(srcVector.getValueCount());
            sortedIndices.setValueCount(srcVector.getValueCount());
            this.indexSorter.sort(srcVector, sortedIndices, comparator);
            int dstOffset = 0;
            dstOffsetBuffer.setInt(0, 0);
            for (int dstIndex = 0; dstIndex < sortedIndices.getValueCount(); ++dstIndex) {
                int srcIndex = sortedIndices.get(dstIndex);
                if (srcVector.isNull(srcIndex)) {
                    BitVectorHelper.setValidityBit((ArrowBuf)dstValidityBuffer, (int)dstIndex, (int)0);
                } else {
                    BitVectorHelper.setValidityBit((ArrowBuf)dstValidityBuffer, (int)dstIndex, (int)1);
                    int srcOffset = srcOffsetBuffer.getInt(srcIndex * 4);
                    int valueLength = srcOffsetBuffer.getInt((srcIndex + 1) * 4) - srcOffset;
                    PlatformDependent.copyMemory((long)(srcValueBuffer.memoryAddress() + (long)srcOffset), (long)(dstValueBuffer.memoryAddress() + (long)dstOffset), (long)valueLength);
                    dstOffset += valueLength;
                }
                dstOffsetBuffer.setInt((dstIndex + 1) * 4, dstOffset);
            }
        }
    }
}

