/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.algorithm.sort;

import org.apache.arrow.algorithm.sort.VectorValueComparator;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.BaseRepeatedValueVector;

public class DefaultVectorComparators {
    public static <T extends ValueVector> VectorValueComparator<T> createDefaultComparator(T vector) {
        if (vector instanceof BaseFixedWidthVector) {
            if (vector instanceof TinyIntVector) {
                return new ByteComparator();
            }
            if (vector instanceof SmallIntVector) {
                return new ShortComparator();
            }
            if (vector instanceof IntVector) {
                return new IntComparator();
            }
            if (vector instanceof BigIntVector) {
                return new LongComparator();
            }
            if (vector instanceof Float4Vector) {
                return new Float4Comparator();
            }
            if (vector instanceof Float8Vector) {
                return new Float8Comparator();
            }
        } else {
            if (vector instanceof BaseVariableWidthVector) {
                return new VariableWidthComparator();
            }
            if (vector instanceof BaseRepeatedValueVector) {
                VectorValueComparator<FieldVector> innerComparator = DefaultVectorComparators.createDefaultComparator(((BaseRepeatedValueVector)vector).getDataVector());
                return new RepeatedValueComparator<FieldVector>(innerComparator);
            }
        }
        throw new IllegalArgumentException("No default comparator for " + vector.getClass().getCanonicalName());
    }

    private DefaultVectorComparators() {
    }

    public static class RepeatedValueComparator<T extends ValueVector>
    extends VectorValueComparator<BaseRepeatedValueVector> {
        private VectorValueComparator<T> innerComparator;

        public RepeatedValueComparator(VectorValueComparator<T> innerComparator) {
            this.innerComparator = innerComparator;
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int endIdx2;
            int length2;
            int startIdx1 = ((BaseRepeatedValueVector)this.vector1).getOffsetBuffer().getInt(index1 * 4);
            int startIdx2 = ((BaseRepeatedValueVector)this.vector2).getOffsetBuffer().getInt(index2 * 4);
            int endIdx1 = ((BaseRepeatedValueVector)this.vector1).getOffsetBuffer().getInt((index1 + 1) * 4);
            int length1 = endIdx1 - startIdx1;
            int length = length1 < (length2 = (endIdx2 = ((BaseRepeatedValueVector)this.vector2).getOffsetBuffer().getInt((index2 + 1) * 4)) - startIdx2) ? length1 : length2;
            for (int i = 0; i < length; ++i) {
                int result = this.innerComparator.compare(startIdx1 + i, startIdx2 + i);
                if (result == 0) continue;
                return result;
            }
            return length1 - length2;
        }

        @Override
        public void attachVectors(BaseRepeatedValueVector vector1, BaseRepeatedValueVector vector2) {
            this.vector1 = vector1;
            this.vector2 = vector2;
            this.innerComparator.attachVectors(vector1.getDataVector(), vector2.getDataVector());
        }
    }

    public static class VariableWidthComparator
    extends VectorValueComparator<BaseVariableWidthVector> {
        private ArrowBufPointer reusablePointer1 = new ArrowBufPointer();
        private ArrowBufPointer reusablePointer2 = new ArrowBufPointer();

        @Override
        public int compare(int index1, int index2) {
            ((BaseVariableWidthVector)this.vector1).getDataPointer(index1, this.reusablePointer1);
            ((BaseVariableWidthVector)this.vector2).getDataPointer(index2, this.reusablePointer2);
            return this.reusablePointer1.compareTo(this.reusablePointer2);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            ((BaseVariableWidthVector)this.vector1).getDataPointer(index1, this.reusablePointer1);
            ((BaseVariableWidthVector)this.vector2).getDataPointer(index2, this.reusablePointer2);
            return this.reusablePointer1.compareTo(this.reusablePointer2);
        }
    }

    public static class Float8Comparator
    extends VectorValueComparator<Float8Vector> {
        public Float8Comparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            double value1 = ((Float8Vector)this.vector1).get(index1);
            double value2 = ((Float8Vector)this.vector2).get(index2);
            boolean isNan1 = Double.isNaN(value1);
            boolean isNan2 = Double.isNaN(value2);
            if (isNan1 || isNan2) {
                if (isNan1 && isNan2) {
                    return 0;
                }
                if (isNan1) {
                    return 1;
                }
                return -1;
            }
            return (int)Math.signum(value1 - value2);
        }
    }

    public static class Float4Comparator
    extends VectorValueComparator<Float4Vector> {
        public Float4Comparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            float value1 = ((Float4Vector)this.vector1).get(index1);
            float value2 = ((Float4Vector)this.vector2).get(index2);
            boolean isNan1 = Float.isNaN(value1);
            boolean isNan2 = Float.isNaN(value2);
            if (isNan1 || isNan2) {
                if (isNan1 && isNan2) {
                    return 0;
                }
                if (isNan1) {
                    return 1;
                }
                return -1;
            }
            return (int)Math.signum(value1 - value2);
        }
    }

    public static class LongComparator
    extends VectorValueComparator<BigIntVector> {
        public LongComparator() {
            super(8);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            long value1 = ((BigIntVector)this.vector1).get(index1);
            long value2 = ((BigIntVector)this.vector2).get(index2);
            return Long.signum(value1 - value2);
        }
    }

    public static class IntComparator
    extends VectorValueComparator<IntVector> {
        public IntComparator() {
            super(4);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            int value1 = ((IntVector)this.vector1).get(index1);
            int value2 = ((IntVector)this.vector2).get(index2);
            return value1 - value2;
        }
    }

    public static class ShortComparator
    extends VectorValueComparator<SmallIntVector> {
        public ShortComparator() {
            super(2);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            short value1 = ((SmallIntVector)this.vector1).get(index1);
            short value2 = ((SmallIntVector)this.vector2).get(index2);
            return value1 - value2;
        }
    }

    public static class ByteComparator
    extends VectorValueComparator<TinyIntVector> {
        public ByteComparator() {
            super(1);
        }

        @Override
        public int compareNotNull(int index1, int index2) {
            byte value1 = ((TinyIntVector)this.vector1).get(index1);
            byte value2 = ((TinyIntVector)this.vector2).get(index2);
            return value1 - value2;
        }
    }
}

