/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.strings;

import aQute.libg.qtokens.QuotedTokenizer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Strings {
    private static final String COMMA = ",";
    private static final Pattern SIMPLE_LIST_SPLITTER = Pattern.compile("\\s*,\\s*");
    private static final Pattern SIMPLE_LINE_SPLITTER = Pattern.compile("\r?\n");

    public static String join(String middle, Iterable<?> objects) {
        if (objects == null) {
            return "";
        }
        return StreamSupport.stream(objects.spliterator(), false).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(middle));
    }

    public static String join(Iterable<?> objects) {
        return Strings.join(COMMA, objects);
    }

    public static String join(String middle, Iterable<?> objects, Pattern pattern, String replace) {
        if (pattern == null) {
            return Strings.join(middle, objects);
        }
        StringBuilder sb = new StringBuilder();
        Strings.join(sb, middle, objects, pattern, replace);
        return sb.toString();
    }

    public static void join(StringBuilder sb, String middle, Iterable<?> objects, Pattern pattern, String replace) {
        if (objects == null) {
            return;
        }
        String del = "";
        for (Object o : objects) {
            if (o == null) continue;
            sb.append(del);
            String s = o.toString();
            if (pattern != null) {
                Matcher matcher = pattern.matcher(s);
                if (!matcher.matches()) continue;
                s = matcher.replaceAll(replace);
            }
            sb.append(s);
            del = middle;
        }
    }

    public static String join(String middle, Object[] segments) {
        return Strings.join(middle, Arrays.asList(segments));
    }

    public static Collector<CharSequence, ?, String> joining() {
        return Collectors.joining(COMMA);
    }

    public static Collector<CharSequence, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix, CharSequence emptyValue) {
        Function<StringJoiner, String> finisher = emptyValue != null ? joiner -> joiner.setEmptyValue(emptyValue).toString() : joiner -> {
            String emptyMarker = new String();
            String joined = joiner.setEmptyValue(emptyMarker).toString();
            return joined != emptyMarker ? joined : null;
        };
        return Collector.of(() -> new StringJoiner(delimiter, prefix, suffix), StringJoiner::add, StringJoiner::merge, finisher, new Collector.Characteristics[0]);
    }

    public static String display(Object o, Object ... ifNull) {
        if (o != null) {
            return o.toString();
        }
        for (int i = 0; i < ifNull.length; ++i) {
            if (ifNull[i] == null) continue;
            return ifNull[i].toString();
        }
        return "";
    }

    public static String join(String[] strings) {
        return Strings.join(Arrays.asList(strings));
    }

    public static String join(Object[] strings) {
        return Strings.join(Arrays.asList(strings));
    }

    public static String getLastSegment(String name, char c) {
        return name.substring(name.lastIndexOf(c) + 1);
    }

    public static String getLastSegment(String name) {
        return Strings.getLastSegment(name, '.');
    }

    public static String trim(String s) {
        int end;
        int start;
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return s;
        }
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        for (end = s.length(); end > start && Character.isWhitespace(s.charAt(end - 1)); --end) {
        }
        if (start == 0 && end == s.length()) {
            return s;
        }
        return s.substring(start, end);
    }

    public static boolean notEmpty(String s) {
        return !s.isEmpty();
    }

    public static boolean nonNullOrEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean nonNullOrTrimmedEmpty(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static Stream<String> splitAsStream(String s) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return Stream.empty();
        }
        return SIMPLE_LIST_SPLITTER.splitAsStream(s).filter(Strings::notEmpty);
    }

    public static List<String> split(String s) {
        return Strings.splitAsStream(s).collect(Collectors.toList());
    }

    public static Stream<String> splitQuotedAsStream(String s) {
        return Strings.splitQuotedAsStream(s, true);
    }

    public static Stream<String> splitQuotedAsStream(String s, boolean retainQuotes) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return Stream.empty();
        }
        return new QuotedTokenizer(s, COMMA, false, retainQuotes).stream().filter(Strings::notEmpty);
    }

    public static Stream<String> splitLinesAsStream(String s) {
        if (s == null) {
            return Stream.empty();
        }
        return SIMPLE_LINE_SPLITTER.splitAsStream(s);
    }

    public static List<String> splitLines(String s) {
        return Strings.splitLinesAsStream(s).collect(Collectors.toList());
    }

    public static List<String> splitQuoted(String s) {
        return Strings.splitQuotedAsStream(s).collect(Collectors.toList());
    }

    public static List<String> split(String regex, String s) {
        if (s == null || (s = s.trim()).isEmpty()) {
            return new ArrayList<String>();
        }
        return Pattern.compile(regex).splitAsStream(s).filter(Strings::notEmpty).collect(Collectors.toList());
    }

    public static boolean in(String[] skip, String key) {
        for (String s : skip) {
            if (!key.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static char charAt(String s, int n) {
        return s.charAt(Strings.adjustBegin(s, n));
    }

    public static String from(String s, int n) {
        return s.substring(Strings.adjustBegin(s, n));
    }

    public static String substring(String s, int begin, int end) {
        return s.substring(Strings.adjustBegin(s, begin), Strings.adjustEnd(s, end));
    }

    public static String substring(String s, int begin, int end, int stride) {
        StringBuilder sb = new StringBuilder();
        begin = Strings.adjustBegin(s, begin);
        end = Strings.adjustEnd(s, end);
        if (stride == 0) {
            stride = 1;
        }
        if (stride < 0) {
            for (int i = end - 1; i >= begin; i += stride) {
                sb.append(s.charAt(i));
            }
        } else {
            for (int i = begin; i < end; i += stride) {
                sb.append(s.charAt(i));
            }
        }
        return sb.toString();
    }

    public static String delete(String s, int begin, int end) {
        return s.substring(0, Strings.adjustBegin(s, begin)) + s.substring(Strings.adjustEnd(s, end));
    }

    public static String to(String s, int end) {
        return s.substring(0, Strings.adjustEnd(s, end));
    }

    public static int adjustBegin(String s, int n) {
        if (n < 0) {
            n = s.length() + n;
        }
        return n;
    }

    public static int adjustEnd(String s, int n) {
        if (n <= 0) {
            n = s.length() + n;
        }
        return n;
    }

    public static String[] extension(String s) {
        return Strings.last(s, '.');
    }

    public static String[] lastPathSegment(String s) {
        return Strings.last(s, '/');
    }

    public static String[] last(String s, char separator) {
        int n = s.lastIndexOf(separator);
        if (n >= 0) {
            String[] answer = new String[]{s.substring(0, n), s.substring(n + 1)};
            return answer;
        }
        return null;
    }

    public static String[] first(String s, char separator) {
        int n = s.indexOf(separator);
        if (n >= 0) {
            String[] answer = new String[]{s.substring(0, n), s.substring(n + 1)};
            return answer;
        }
        return null;
    }

    public static String stripPrefix(String s, String prefix) {
        Pattern p = Pattern.compile(prefix);
        return Strings.stripPrefix(s, p);
    }

    public static String stripPrefix(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        if (matcher.lookingAt()) {
            return s.substring(matcher.end());
        }
        return null;
    }

    public static String stripSuffix(String s, String prefix) {
        Pattern p = Pattern.compile(prefix);
        return Strings.stripSuffix(s, p);
    }

    public static String stripSuffix(String s, Pattern p) {
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            if (matcher.end() != s.length()) continue;
            return s.substring(0, matcher.start());
        }
        return null;
    }

    public static String ensureSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s;
        }
        return s + suffix;
    }

    public static String ensurePrefix(String s, String prefix) {
        if (s.startsWith(prefix)) {
            return s;
        }
        return prefix + s;
    }

    public static String times(String s, int times) {
        if (times <= 1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(times * s.length());
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String format(String string, Object ... parms) {
        if (parms == null) {
            parms = new Object[]{};
        }
        return String.format(string, Strings.makePrintableArray(parms));
    }

    private static Object[] makePrintableArray(Object array) {
        int length = Array.getLength(array);
        Object[] output = new Object[length];
        for (int i = 0; i < length; ++i) {
            output[i] = Strings.makePrintable(Array.get(array, i));
        }
        return output;
    }

    private static Object makePrintable(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            return Arrays.toString(Strings.makePrintableArray(object));
        }
        return object;
    }

    public static boolean compareExcept(String a, String b, Pattern pattern) {
        Matcher ma = pattern.matcher(a);
        Matcher mb = pattern.matcher(b);
        int ra = 0;
        int rb = 0;
        while (ma.find()) {
            int sb;
            if (!mb.find()) {
                return false;
            }
            int sa = ma.start(1);
            if (sa - ra != (sb = mb.start(1)) - rb) {
                return false;
            }
            for (int i = 0; i < sa - ra; ++i) {
                if (a.charAt(ra + i) == b.charAt(rb + i)) continue;
                return false;
            }
            ra = ma.end() + 1;
            rb = mb.end() + 1;
        }
        if (a.length() - ra != b.length() - rb) {
            return false;
        }
        for (int i = 0; i < a.length() - ra; ++i) {
            if (a.charAt(ra + i) == b.charAt(rb + i)) continue;
            return false;
        }
        return true;
    }
}

