/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.quiesce.manager.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.aries.quiesce.manager.QuiesceCallback;
import org.apache.aries.quiesce.manager.QuiesceManager;
import org.apache.aries.quiesce.participant.QuiesceParticipant;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuiesceManagerImpl
implements QuiesceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QuiesceManagerImpl.class.getName());
    private static final MessageUtil MESSAGES = MessageUtil.createMessageUtil(QuiesceManagerImpl.class, (String)"org.apache.aries.quiesce.manager.nls.quiesceMessages");
    private static int defaultTimeout = 60000;
    private BundleContext bundleContext = null;
    private ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(10, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Quiesce Manager Timeout Thread");
            t.setDaemon(true);
            return t;
        }
    });
    private ExecutorService executor = new ThreadPoolExecutor(0, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable arg0) {
            Thread t = new Thread(arg0, "Quiesce Manager Thread");
            t.setDaemon(true);
            return t;
        }
    });
    private static ConcurrentHashMap<Bundle, Bundle> bundleMap = new ConcurrentHashMap();

    public QuiesceManagerImpl(BundleContext bc) {
        this.bundleContext = bc;
    }

    public void quiesce(long timeout, List<Bundle> bundles) {
        this.quiesceWithFuture(timeout, bundles);
    }

    public Future<?> quiesceWithFuture(List<Bundle> bundlesToQuiesce) {
        return this.quiesceWithFuture(defaultTimeout, bundlesToQuiesce);
    }

    public Future<?> quiesceWithFuture(long timeout, List<Bundle> bundles) {
        QuiesceFuture result = new QuiesceFuture();
        if (bundles != null && !bundles.isEmpty()) {
            Iterator<Bundle> it = bundles.iterator();
            HashSet<Bundle> bundlesToQuiesce = new HashSet<Bundle>();
            while (it.hasNext()) {
                Bundle b = it.next();
                Bundle priorBundle = bundleMap.putIfAbsent(b, b);
                if (priorBundle == null) {
                    bundlesToQuiesce.add(b);
                    continue;
                }
                LOGGER.warn(MESSAGES.getMessage("already.quiescing.bundle", new Object[]{b.getSymbolicName() + '/' + b.getVersion()}));
            }
            BundleQuiescer command = new BundleQuiescer(bundlesToQuiesce, timeout, result, bundleMap);
            this.executor.execute(command);
            return result;
        }
        result.registerDone();
        return result;
    }

    public void quiesce(List<Bundle> bundlesToQuiesce) {
        this.quiesce(defaultTimeout, bundlesToQuiesce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean stopBundle(Bundle bundleToStop, Set<Bundle> bundlesToStop) {
        try {
            Set<Bundle> set = bundlesToStop;
            synchronized (set) {
                if (bundlesToStop.remove(bundleToStop)) {
                    bundleToStop.stop();
                    bundleMap.remove(bundleToStop);
                }
            }
        }
        catch (BundleException be) {
            return false;
        }
        return true;
    }

    private static boolean stillQuiescing(Bundle bundleToStop) {
        return bundleMap.containsKey(bundleToStop);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QuiesceCallbackImpl
    implements QuiesceCallback {
        private final Set<Bundle> toQuiesce;
        private final Set<Bundle> toQuiesceShared;
        private final List<QuiesceCallbackImpl> allCallbacks;
        private final QuiesceFuture future;
        private final ScheduledFuture<?> timeoutFuture;

        public QuiesceCallbackImpl(Set<Bundle> toQuiesce, List<QuiesceCallbackImpl> allCallbacks, QuiesceFuture future, ScheduledFuture<?> timeoutFuture) {
            this.toQuiesce = new HashSet<Bundle>(toQuiesce);
            this.toQuiesceShared = toQuiesce;
            this.allCallbacks = allCallbacks;
            this.future = future;
            this.timeoutFuture = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleQuiesced(Bundle ... bundlesQuiesced) {
            boolean timeoutOccurred = false;
            List<QuiesceCallbackImpl> list = this.allCallbacks;
            synchronized (list) {
                for (Bundle b : bundlesQuiesced) {
                    if (QuiesceManagerImpl.stillQuiescing(b)) {
                        if (!this.toQuiesce.remove(b) || !this.checkOthers(b)) continue;
                        QuiesceManagerImpl.stopBundle(b, this.toQuiesceShared);
                        if (!this.allCallbacksComplete()) continue;
                        this.future.registerDone();
                        this.timeoutFuture.cancel(false);
                        LOGGER.debug("Quiesce complete");
                        continue;
                    }
                    timeoutOccurred = true;
                    break;
                }
                if (timeoutOccurred) {
                    Iterator<QuiesceCallbackImpl> it = this.allCallbacks.iterator();
                    while (it.hasNext()) {
                        it.next().toQuiesce.clear();
                    }
                }
            }
        }

        private boolean checkOthers(Bundle b) {
            boolean allDone = true;
            Iterator<QuiesceCallbackImpl> it = this.allCallbacks.iterator();
            while (allDone && it.hasNext()) {
                allDone = !it.next().toQuiesce.contains(b);
            }
            return allDone;
        }

        private boolean allCallbacksComplete() {
            boolean allDone = true;
            Iterator<QuiesceCallbackImpl> it = this.allCallbacks.iterator();
            while (allDone && it.hasNext()) {
                QuiesceCallbackImpl next = it.next();
                if (next.toQuiesce.isEmpty()) continue;
                allDone = false;
            }
            return allDone;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BundleQuiescer
    implements Runnable {
        private final Set<Bundle> bundlesToQuiesce;
        private final long timeout;
        private final QuiesceFuture future;

        public BundleQuiescer(Set<Bundle> bundlesToQuiesce, long timeout, QuiesceFuture future, ConcurrentHashMap<Bundle, Bundle> bundleMap) {
            this.bundlesToQuiesce = new HashSet<Bundle>(bundlesToQuiesce);
            this.timeout = timeout;
            this.future = future;
        }

        @Override
        public void run() {
            try {
                if (QuiesceManagerImpl.this.bundleContext != null) {
                    ServiceReference[] serviceRefs = QuiesceManagerImpl.this.bundleContext.getServiceReferences(QuiesceParticipant.class.getName(), null);
                    if (serviceRefs != null) {
                        ArrayList<QuiesceParticipant> participants = new ArrayList<QuiesceParticipant>();
                        ArrayList<QuiesceCallbackImpl> callbacks = new ArrayList<QuiesceCallbackImpl>();
                        ArrayList<Bundle> copyOfBundles = new ArrayList<Bundle>(this.bundlesToQuiesce);
                        ScheduledFuture<?> timeoutFuture = QuiesceManagerImpl.this.timeoutExecutor.schedule(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    Set set = BundleQuiescer.this.bundlesToQuiesce;
                                    synchronized (set) {
                                        for (Bundle b : new ArrayList(BundleQuiescer.this.bundlesToQuiesce)) {
                                            LOGGER.warn(MESSAGES.getMessage("quiesce.failed", new Object[]{b.getSymbolicName() + '/' + b.getVersion()}));
                                            QuiesceManagerImpl.stopBundle(b, BundleQuiescer.this.bundlesToQuiesce);
                                        }
                                    }
                                }
                                finally {
                                    BundleQuiescer.this.future.registerDone();
                                    LOGGER.debug("Quiesce complete");
                                }
                            }
                        }, this.timeout, TimeUnit.MILLISECONDS);
                        for (ServiceReference sr : serviceRefs) {
                            QuiesceParticipant participant = (QuiesceParticipant)QuiesceManagerImpl.this.bundleContext.getService(sr);
                            participants.add(participant);
                            callbacks.add(new QuiesceCallbackImpl(this.bundlesToQuiesce, callbacks, this.future, timeoutFuture));
                        }
                        for (int i = 0; i < participants.size(); ++i) {
                            QuiesceParticipant participant = (QuiesceParticipant)participants.get(i);
                            QuiesceCallbackImpl callback = (QuiesceCallbackImpl)callbacks.get(i);
                            participant.quiesce((QuiesceCallback)callback, copyOfBundles);
                        }
                    } else {
                        for (Bundle b : this.bundlesToQuiesce) {
                            QuiesceManagerImpl.stopBundle(b, this.bundlesToQuiesce);
                        }
                        this.future.registerDone();
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warn(MESSAGES.getMessage("null.is.invalid.filter", new Object[0]));
                for (Bundle b : this.bundlesToQuiesce) {
                    QuiesceManagerImpl.stopBundle(b, this.bundlesToQuiesce);
                }
                this.future.registerDone();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QuiesceFuture
    implements Future<Object> {
        private CountDownLatch latch = new CountDownLatch(1);

        private QuiesceFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException(MESSAGES.getMessage("quiesce.cannot.be.canceled", new Object[0]));
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.latch.await(timeout, unit)) {
                throw new TimeoutException();
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        public void registerDone() {
            if (!this.isDone()) {
                this.latch.countDown();
            }
        }
    }
}

