/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.interfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.ProxyUtils;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyAdapter;
import org.apache.aries.proxy.impl.common.OSGiFriendlyClassVisitor;
import org.apache.aries.proxy.impl.common.OSGiFriendlyClassWriter;
import org.apache.aries.proxy.impl.interfaces.InterfaceUsingWovenProxyAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InterfaceCombiningClassAdapter
extends ClassVisitor
implements Opcodes {
    private final Class<?> superclass;
    private final Collection<Class<?>> interfaces;
    private final ClassWriter writer;
    private final AbstractWovenProxyAdapter adapter;
    private boolean done = false;

    InterfaceCombiningClassAdapter(String className, ClassLoader loader, Class<?> superclass, Collection<Class<?>> interfaces) {
        super(262144);
        this.writer = new OSGiFriendlyClassWriter(2, loader);
        OSGiFriendlyClassVisitor cv = new OSGiFriendlyClassVisitor((ClassVisitor)this.writer, 2);
        this.adapter = new InterfaceUsingWovenProxyAdapter(cv, className, loader);
        this.interfaces = interfaces;
        this.superclass = superclass;
        String[] interfaceNames = new String[interfaces.size()];
        int i = 0;
        for (Class<?> in : interfaces) {
            interfaceNames[i] = Type.getInternalName(in);
            ++i;
        }
        this.adapter.visit(ProxyUtils.getWeavingJavaVersion(), 4097, className, null, superclass == null ? AbstractWovenProxyAdapter.OBJECT_TYPE.getInternalName() : Type.getInternalName(superclass), interfaceNames);
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] arg4) {
        if (this.adapter.getKnownMethods().contains(new Method(name, desc)) || "<clinit>".equals(name)) {
            return null;
        }
        return this.adapter.visitMethod(access, name, desc, null, arg4);
    }

    final byte[] generateBytes() throws UnableToProxyException {
        if (!this.done) {
            for (Class<?> c : this.interfaces) {
                this.adapter.setCurrentMethodDeclaringType(Type.getType(c), true);
                try {
                    AbstractWovenProxyAdapter.readClass(c, this);
                }
                catch (IOException e) {
                    throw new UnableToProxyException(c, (Throwable)e);
                }
            }
            for (Class<?> clazz = this.superclass; clazz != null && (clazz.getModifiers() & 0x400) != 0; clazz = clazz.getSuperclass()) {
                this.adapter.setCurrentMethodDeclaringType(Type.getType(clazz), false);
                this.visitAbstractMethods(clazz);
            }
            this.adapter.setCurrentMethodDeclaringType(AbstractWovenProxyAdapter.OBJECT_TYPE, false);
            this.visitObjectMethods();
            this.adapter.visitEnd();
            this.done = true;
        }
        return this.writer.toByteArray();
    }

    private void visitAbstractMethods(Class<?> clazz) {
        for (java.lang.reflect.Method m : clazz.getDeclaredMethods()) {
            int modifiers = m.getModifiers();
            if ((modifiers & 0x400) == 0) continue;
            ArrayList<String> exceptions = new ArrayList<String>();
            for (Class<?> c : m.getExceptionTypes()) {
                exceptions.add(Type.getInternalName(c));
            }
            MethodVisitor visitor = this.visitMethod(modifiers, m.getName(), Method.getMethod((java.lang.reflect.Method)m).getDescriptor(), null, exceptions.toArray(new String[exceptions.size()]));
            if (visitor == null) continue;
            visitor.visitEnd();
        }
    }

    private void visitObjectMethods() {
        MethodVisitor visitor = this.visitMethod(1025, "toString", "()Ljava/lang/String;", null, null);
        if (visitor != null) {
            visitor.visitEnd();
        }
        if ((visitor = this.visitMethod(1025, "equals", "(Ljava/lang/Object;)Z", null, null)) != null) {
            visitor.visitEnd();
        }
        if ((visitor = this.visitMethod(1025, "hashCode", "()I", null, null)) != null) {
            visitor.visitEnd();
        }
    }
}

