/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.common;

import java.util.Map;
import java.util.Set;
import org.apache.aries.proxy.FinalModifierException;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyAdapter;
import org.apache.aries.proxy.impl.common.AbstractWovenProxyMethodAdapter;
import org.apache.aries.proxy.impl.common.TypeMethod;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodCopyingClassAdapter
extends ClassVisitor
implements Opcodes {
    private final Class<?> superToCopy;
    private final boolean samePackage;
    private final Type overridingClassType;
    private final Set<Method> knownMethods;
    private final Map<String, TypeMethod> transformedMethods;
    private final AbstractWovenProxyAdapter wovenProxyAdapter;

    public MethodCopyingClassAdapter(AbstractWovenProxyAdapter awpa, ClassLoader definingLoader, Class<?> superToCopy, Type overridingClassType, Set<Method> knownMethods, Map<String, TypeMethod> transformedMethods) {
        super(262144);
        this.wovenProxyAdapter = awpa;
        this.superToCopy = superToCopy;
        this.overridingClassType = overridingClassType;
        this.knownMethods = knownMethods;
        this.transformedMethods = transformedMethods;
        if (definingLoader != superToCopy.getClassLoader()) {
            this.samePackage = false;
        } else {
            int lastIndex2;
            String overridingClassName = overridingClassType.getClassName();
            int lastIndex1 = superToCopy.getName().lastIndexOf(46);
            this.samePackage = lastIndex1 != (lastIndex2 = overridingClassName.lastIndexOf(46)) ? false : (lastIndex1 == -1 ? true : superToCopy.getName().substring(0, lastIndex1).equals(overridingClassName.substring(0, lastIndex2)));
        }
    }

    public final MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        CopyingMethodAdapter mv = null;
        if (!name.equals("<init>") && !name.equals("<clinit>") && (access & 0x154A) == 0) {
            Method currentTransformMethod = new Method(name, desc);
            if (!this.knownMethods.add(currentTransformMethod)) {
                return null;
            }
            if ((access & 0x10) != 0) {
                throw new RuntimeException((Throwable)new FinalModifierException(this.superToCopy, name));
            }
            if ((access & 7) == 0 && !this.samePackage) {
                throw new RuntimeException(NLS.MESSAGES.getMessage("method.from.superclass.is.hidden", new Object[]{name, this.superToCopy.getName(), this.overridingClassType.getClassName()}), (Throwable)new UnableToProxyException(this.superToCopy));
            }
            Type superType = Type.getType(this.superToCopy);
            String methodStaticFieldName = "methodField" + AbstractWovenProxyAdapter.getSanitizedUUIDString();
            this.transformedMethods.put(methodStaticFieldName, new TypeMethod(superType, currentTransformMethod));
            MethodVisitor weaver = this.wovenProxyAdapter.getWeavingMethodVisitor(access, name, desc, sig, exceptions, currentTransformMethod, methodStaticFieldName, superType, false);
            if (weaver instanceof AbstractWovenProxyMethodAdapter) {
                if (!this.samePackage && (access & 4) != 0) {
                    throw new RuntimeException(NLS.MESSAGES.getMessage("method.from.superclass.is.hidden", new Object[]{name, this.superToCopy.getName(), this.overridingClassType.getClassName()}), (Throwable)new UnableToProxyException(this.superToCopy));
                }
                mv = new CopyingMethodAdapter((GeneratorAdapter)weaver, superType, currentTransformMethod);
            } else {
                mv = new CopyingMethodAdapter(new GeneratorAdapter(access, currentTransformMethod, mv), superType, currentTransformMethod);
            }
        }
        return mv;
    }

    private static final class CopyingMethodAdapter
    extends MethodVisitor {
        private final GeneratorAdapter mv;
        private final Type superType;
        private final Method currentTransformMethod;

        public CopyingMethodAdapter(GeneratorAdapter mv, Type superType, Method currentTransformMethod) {
            super(262144);
            this.mv = mv;
            this.superType = superType;
            this.currentTransformMethod = currentTransformMethod;
        }

        public final AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return this.mv.visitAnnotation(arg0, arg1);
        }

        public final AnnotationVisitor visitAnnotationDefault() {
            return this.mv.visitAnnotationDefault();
        }

        public final AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
            return this.mv.visitParameterAnnotation(arg0, arg1, arg2);
        }

        public final void visitAttribute(Attribute attr) {
            this.mv.visitAttribute(attr);
        }

        public final void visitEnd() {
            this.mv.visitCode();
            this.mv.loadThis();
            this.mv.loadArgs();
            this.mv.visitMethodInsn(183, this.superType.getInternalName(), this.currentTransformMethod.getName(), this.currentTransformMethod.getDescriptor());
            this.mv.returnValue();
            this.mv.visitMaxs(this.currentTransformMethod.getArgumentTypes().length + 1, 0);
            this.mv.visitEnd();
        }
    }
}

