/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.jpa.container.impl.PersistenceProviderTracker;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnitParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceBundleTracker
implements BundleTrackerCustomizer<Bundle> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceBundleTracker.class);
    private final Map<Bundle, Collection<PersistenceProviderTracker>> trackers = new HashMap<Bundle, Collection<PersistenceProviderTracker>>();
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public PersistenceBundleTracker() {
        this.typeMap.put(1, "INSTALLED");
        this.typeMap.put(512, "LAZY_ACTIVATION");
        this.typeMap.put(32, "RESOLVED");
        this.typeMap.put(2, "STARTED");
        this.typeMap.put(128, "Starting");
        this.typeMap.put(4, "STOPPED");
        this.typeMap.put(16, "UNINSTALLED");
        this.typeMap.put(256, "UNRESOLVED");
        this.typeMap.put(8, "UPDATED");
    }

    public synchronized Bundle addingBundle(Bundle bundle, BundleEvent event) {
        if (event != null && event.getType() == 4) {
            return bundle;
        }
        if (this.getTrackers(bundle).isEmpty()) {
            this.findPersistenceUnits(bundle, event);
        }
        return bundle;
    }

    public synchronized void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        Collection<PersistenceProviderTracker> providerTrackers = this.trackers.remove(bundle);
        if (providerTrackers == null || providerTrackers.isEmpty()) {
            return;
        }
        LOGGER.info("removing persistence units for " + bundle.getSymbolicName() + " " + this.getType(event));
        for (PersistenceProviderTracker providerTracker : providerTrackers) {
            providerTracker.close();
        }
        providerTrackers.clear();
    }

    private void findPersistenceUnits(Bundle bundle, BundleEvent event) {
        for (PersistenceUnit punit : PersistenceUnitParser.getPersistenceUnits(bundle)) {
            punit.addAnnotated();
            this.trackProvider(bundle, punit);
        }
        if (!this.getTrackers(bundle).isEmpty()) {
            LOGGER.info("Persistence units added for bundle " + bundle.getSymbolicName() + " event " + PersistenceBundleTracker.getEventType(event));
        }
    }

    private static Integer getEventType(BundleEvent event) {
        return event != null ? Integer.valueOf(event.getType()) : null;
    }

    private void trackProvider(Bundle bundle, PersistenceUnit punit) {
        LOGGER.info(String.format("Found persistence unit %s in bundle %s with provider %s.", punit.getPersistenceUnitName(), bundle.getSymbolicName(), punit.getPersistenceProviderClassName()));
        PersistenceProviderTracker tracker = new PersistenceProviderTracker(bundle.getBundleContext(), punit);
        tracker.open();
        this.getTrackers(bundle).add(tracker);
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
    }

    private String getType(BundleEvent event) {
        if (event == null) {
            return "null";
        }
        int type = event.getType();
        String typeSt = this.typeMap.get(type);
        return typeSt != null ? typeSt : "unknown event type: " + type;
    }

    private Collection<PersistenceProviderTracker> getTrackers(Bundle bundle) {
        Collection<PersistenceProviderTracker> providerTrackers = this.trackers.get(bundle);
        if (providerTrackers == null) {
            providerTrackers = new ArrayList<PersistenceProviderTracker>();
            this.trackers.put(bundle, providerTrackers);
        }
        return providerTrackers;
    }
}

