/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedEMF
implements Closeable,
ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedEMF.class);
    private static final String JPA_CONFIGURATION_PREFIX = "org.apache.aries.jpa.";
    private EntityManagerFactory emf;
    private ServiceRegistration<EntityManagerFactory> reg;
    private PersistenceProvider provider;
    private PersistenceUnitInfo persistenceUnit;
    private Bundle bundle;
    private ServiceRegistration<?> configReg;
    private boolean closed;

    public ManagedEMF(BundleContext containerContext, Bundle bundle, PersistenceProvider provider, PersistenceUnitInfo persistenceUnit) {
        this.provider = provider;
        this.persistenceUnit = persistenceUnit;
        this.bundle = bundle;
        this.registerManagedService(containerContext, persistenceUnit);
        this.closed = false;
    }

    private void registerManagedService(BundleContext containerContext, PersistenceUnitInfo persistenceUnit) {
        Hashtable<String, String> configuration = new Hashtable<String, String>();
        ((Dictionary)configuration).put("service.pid", JPA_CONFIGURATION_PREFIX + persistenceUnit.getPersistenceUnitName());
        this.configReg = containerContext.registerService(ManagedService.class.getName(), (Object)this, configuration);
    }

    public void closeEMF() {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (Exception e) {
                LOGGER.debug("Exception on unregister", (Throwable)e);
            }
        }
        if (this.emf != null && this.emf.isOpen()) {
            try {
                this.emf.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing EntityManagerFactory for " + this.persistenceUnit.getPersistenceUnitName(), (Throwable)e);
            }
        }
        this.reg = null;
        this.emf = null;
    }

    @Override
    public void close() {
        this.closed = true;
        this.closeEMF();
        if (this.configReg != null) {
            this.configReg.unregister();
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (this.closed) {
            return;
        }
        if (this.emf != null) {
            this.closeEMF();
        }
        if (this.bundle.getState() == 1 || this.bundle.getState() == 2 || this.bundle.getState() == 16) {
            return;
        }
        Map<String, Object> overrides = properties != null ? this.asMap(properties) : null;
        LOGGER.info("Registering EntityManagerFactory for persistence unit " + this.persistenceUnit.getPersistenceUnitName());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using properties override " + overrides);
        }
        this.createAndPublishEMF(overrides);
    }

    private void createAndPublishEMF(Map<String, Object> overrides) {
        this.emf = this.provider.createContainerEntityManagerFactory(this.persistenceUnit, overrides);
        Dictionary<String, String> props = ManagedEMF.createProperties(this.persistenceUnit, this.bundle);
        BundleContext uctx = this.bundle.getBundleContext();
        this.reg = uctx.registerService(EntityManagerFactory.class, (Object)this.emf, props);
    }

    public static Dictionary<String, String> createProperties(PersistenceUnitInfo persistenceUnit, Bundle puBundle) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.unit.name", persistenceUnit.getPersistenceUnitName());
        if (persistenceUnit.getPersistenceProviderClassName() != null) {
            ((Dictionary)props).put("osgi.unit.provider", persistenceUnit.getPersistenceProviderClassName());
        }
        ((Dictionary)props).put("osgi.unit.version", puBundle.getVersion().toString());
        return props;
    }

    private Map<String, Object> asMap(Dictionary<String, ?> dict) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PersistenceUnitTransactionType.class.getName(), this.persistenceUnit.getTransactionType());
        Enumeration<String> e = dict.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            map.put(key, dict.get(key));
        }
        return map;
    }
}

