/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.sql.SQLException;
import java.util.Properties;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.impl.ManagedEMF;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSFTracker
extends ServiceTracker<DataSourceFactory, ManagedEMF> {
    private static final String JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JDBC_URL = "javax.persistence.jdbc.url";
    private static final String JDBC_USER = "javax.persistence.jdbc.user";
    private static final String JDBC_PASSWORD = "javax.persistence.jdbc.password";
    private static final Logger LOGGER = LoggerFactory.getLogger(DSFTracker.class);
    private PersistenceProvider provider;
    private PersistenceUnit punit;

    public DSFTracker(BundleContext context, PersistenceProvider provider, PersistenceUnit punit) {
        super(context, DSFTracker.createFilter(context, punit), null);
        this.provider = provider;
        this.punit = punit;
    }

    static Filter createFilter(BundleContext context, PersistenceUnit punit) {
        String driverName = DSFTracker.getDriverName(punit);
        if (driverName == null) {
            throw new IllegalArgumentException("No javax.persistence.jdbc.driver supplied in persistence.xml");
        }
        String filter = String.format("(&(objectClass=%s)(%s=%s))", DataSourceFactory.class.getName(), "osgi.jdbc.driver.class", driverName);
        LOGGER.info("Tracking DataSourceFactory for punit " + punit.getPersistenceUnitName() + " with filter " + filter);
        try {
            return context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getDriverName(PersistenceUnit punit) {
        return (String)punit.getProperties().get(JDBC_DRIVER);
    }

    public ManagedEMF addingService(ServiceReference<DataSourceFactory> reference) {
        LOGGER.info("Found DataSourceFactory for " + this.punit.getPersistenceUnitName() + " " + DSFTracker.getDriverName(this.punit));
        try {
            DataSourceFactory dsf = (DataSourceFactory)this.context.getService(reference);
            DataSource ds = this.createDataSource(dsf);
            if (this.punit.getTransactionType() == PersistenceUnitTransactionType.JTA) {
                this.punit.setJtaDataSource(ds);
            } else {
                this.punit.setNonJtaDataSource(ds);
            }
            BundleContext containerContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
            return new ManagedEMF(containerContext, this.punit.getBundle(), this.provider, this.punit);
        }
        catch (Exception e) {
            LOGGER.error("Error creating DataSource for punit " + this.punit.getPersistenceUnitName(), (Throwable)e);
            return null;
        }
    }

    private DataSource createDataSource(DataSourceFactory dsf) {
        try {
            Properties props = new Properties();
            DSFTracker.put(props, "url", this.punit, JDBC_URL);
            DSFTracker.put(props, "user", this.punit, JDBC_USER);
            DSFTracker.put(props, "password", this.punit, JDBC_PASSWORD);
            return dsf.createDataSource(props);
        }
        catch (SQLException e) {
            String msg = "Error creating DataSource for persistence unit " + this.punit + "." + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    private static void put(Properties props, String destKey, PersistenceUnit punit, String sourceKey) {
        Object value = punit.getProperties().get(sourceKey);
        if (value != null) {
            props.put(destKey, value);
        }
    }

    public void removedService(ServiceReference<DataSourceFactory> reference, ManagedEMF managedEMF) {
        LOGGER.info("Lost DataSourceFactory for " + this.punit.getPersistenceUnitName() + " " + DSFTracker.getDriverName(this.punit));
        managedEMF.close();
        super.removedService(reference, (Object)managedEMF);
    }
}

