/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.impl;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.aries.jpa.container.parser.impl.PersistenceUnit;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class AriesEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    private static final String JAVAX_PERSISTENCE_JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JAVAX_PERSISTENCE_JTA_DATASOURCE = "javax.persistence.jtaDataSource";
    private static final String JAVAX_PERSISTENCE_NON_JTA_DATASOURCE = "javax.persistence.nonJtaDataSource";
    private static final String JAVAX_PERSISTENCE_TX_TYPE = "javax.persistence.transactionType";
    private PersistenceProvider provider;
    private PersistenceUnit persistenceUnit;
    private String driver;

    public AriesEntityManagerFactoryBuilder(PersistenceProvider provider, PersistenceUnit persistenceUnit) {
        this.provider = provider;
        this.persistenceUnit = persistenceUnit;
        this.driver = (String)persistenceUnit.getProperties().get(JAVAX_PERSISTENCE_JDBC_DRIVER);
    }

    public EntityManagerFactory createEntityManagerFactory(Map<String, Object> props) {
        props = new HashMap<String, Object>(props);
        String newDriver = (String)props.get(JAVAX_PERSISTENCE_JDBC_DRIVER);
        if (this.driver == null) {
            this.driver = newDriver;
        } else if (newDriver != null && !newDriver.equals(this.driver)) {
            throw new IllegalArgumentException("Can not rebind to a different database driver");
        }
        Object o = props.get(JAVAX_PERSISTENCE_JTA_DATASOURCE);
        if (o instanceof DataSource) {
            this.persistenceUnit.setJtaDataSource((DataSource)o);
            props.remove(JAVAX_PERSISTENCE_JTA_DATASOURCE);
        }
        if ((o = props.get(JAVAX_PERSISTENCE_NON_JTA_DATASOURCE)) instanceof DataSource) {
            this.persistenceUnit.setNonJtaDataSource((DataSource)o);
            props.remove(JAVAX_PERSISTENCE_NON_JTA_DATASOURCE);
        }
        if ((o = props.get(JAVAX_PERSISTENCE_TX_TYPE)) instanceof PersistenceUnitTransactionType) {
            this.persistenceUnit.setTransactionType((PersistenceUnitTransactionType)o);
        } else if (o instanceof String) {
            this.persistenceUnit.setTransactionType(PersistenceUnitTransactionType.valueOf((String)((String)o)));
        }
        return this.provider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnit, props);
    }
}

