/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parsing.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptor;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParser;
import org.apache.aries.jpa.container.parsing.PersistenceDescriptorParserException;
import org.apache.aries.jpa.container.parsing.impl.EarlyParserReturn;
import org.apache.aries.jpa.container.parsing.impl.JPAHandler;
import org.apache.aries.jpa.container.parsing.impl.PersistenceUnitImpl;
import org.apache.aries.jpa.container.parsing.impl.SchemaLocatingHandler;
import org.apache.aries.util.io.RememberingInputStream;
import org.osgi.framework.Bundle;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceDescriptorParserImpl
implements PersistenceDescriptorParser {
    public Collection<? extends ParsedPersistenceUnit> parse(Bundle b, PersistenceDescriptor descriptor) throws PersistenceDescriptorParserException {
        ArrayList<PersistenceUnitImpl> persistenceUnits = new ArrayList<PersistenceUnitImpl>();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        RememberingInputStream is = null;
        boolean schemaFound = false;
        try {
            is = new RememberingInputStream(descriptor.getInputStream());
            is.mark(Integer.MAX_VALUE);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                parser.parse((InputStream)is, (DefaultHandler)new SchemaLocatingHandler());
            }
            catch (EarlyParserReturn epr) {
                Schema s = epr.getSchema();
                if (s != null) {
                    schemaFound = true;
                    parserFactory.setSchema(s);
                    parserFactory.setNamespaceAware(true);
                    parser = parserFactory.newSAXParser();
                    is.reset();
                    JPAHandler handler = new JPAHandler(b, epr.getVersion());
                    parser.parse((InputStream)is, (DefaultHandler)handler);
                    persistenceUnits.addAll(handler.getPersistenceUnits());
                }
            }
        }
        catch (Exception e) {
            throw new PersistenceDescriptorParserException(NLS.MESSAGES.getMessage("persistence.description.parse.error", new Object[]{descriptor.getLocation(), b.getSymbolicName(), b.getVersion()}), e);
        }
        finally {
            if (is != null) {
                try {
                    is.closeUnderlying();
                }
                catch (IOException e) {}
            }
        }
        if (!schemaFound) {
            throw new PersistenceDescriptorParserException(NLS.MESSAGES.getMessage("persistence.descriptor.schema.not.found", new Object[]{descriptor.getLocation(), b.getSymbolicName(), b.getVersion()}));
        }
        return persistenceUnits;
    }
}

