/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.context.transaction.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.apache.aries.jpa.container.context.transaction.impl.DestroyCallback;
import org.apache.aries.jpa.container.context.transaction.impl.JTAPersistenceContextRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTAEntityManager
implements EntityManager {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.jpa.container.context");
    private final EntityManagerFactory emf;
    private final Map<String, Object> props;
    private final JTAPersistenceContextRegistry reg;
    private final AtomicLong instanceCount;
    private final DestroyCallback callback;
    private EntityManager detachedManager = null;

    public JTAEntityManager(EntityManagerFactory factory, Map<String, Object> properties, JTAPersistenceContextRegistry registry, AtomicLong activeCount, DestroyCallback onDestroy) {
        this.emf = factory;
        this.props = properties;
        this.reg = registry;
        this.instanceCount = activeCount;
        this.callback = onDestroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntityManager getPersistenceContext(boolean forceTransaction) {
        if (forceTransaction) {
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (this.reg.isTransactionActive()) {
            return this.reg.getCurrentPersistenceContext(this.emf, this.props, this.instanceCount, this.callback);
        }
        if (!this.reg.jtaIntegrationAvailable() && _logger.isDebugEnabled()) {
            _logger.debug("No integration with JTA transactions is available. No transaction context is active.");
        }
        if (this.detachedManager == null) {
            EntityManager temp = this.emf.createEntityManager(this.props);
            JTAEntityManager jTAEntityManager = this;
            synchronized (jTAEntityManager) {
                if (this.detachedManager == null) {
                    this.detachedManager = temp;
                    temp = null;
                }
            }
            if (temp != null) {
                temp.close();
            }
        }
        return this.detachedManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose() {
        EntityManager temp = null;
        JTAEntityManager jTAEntityManager = this;
        synchronized (jTAEntityManager) {
            temp = this.detachedManager;
            this.detachedManager = null;
        }
        if (temp != null) {
            temp.close();
        }
    }

    public void clear() {
        this.getPersistenceContext(false).clear();
    }

    public void close() {
        throw new IllegalStateException("It is forbidden to call close on a container managed EntityManager");
    }

    public boolean contains(Object arg0) {
        return this.getPersistenceContext(false).contains(arg0);
    }

    public Query createNamedQuery(String arg0) {
        return this.getPersistenceContext(false).createNamedQuery(arg0);
    }

    public Query createNativeQuery(String arg0) {
        return this.getPersistenceContext(false).createNativeQuery(arg0);
    }

    public Query createNativeQuery(String arg0, Class arg1) {
        return this.getPersistenceContext(false).createNativeQuery(arg0, arg1);
    }

    public Query createNativeQuery(String arg0, String arg1) {
        return this.getPersistenceContext(false).createNativeQuery(arg0, arg1);
    }

    public Query createQuery(String arg0) {
        return this.getPersistenceContext(false).createQuery(arg0);
    }

    public <T> T find(Class<T> arg0, Object arg1) {
        return (T)this.getPersistenceContext(false).find(arg0, arg1);
    }

    public void flush() {
        this.getPersistenceContext(true).flush();
    }

    public Object getDelegate() {
        return this.getPersistenceContext(false).getDelegate();
    }

    public FlushModeType getFlushMode() {
        return this.getPersistenceContext(false).getFlushMode();
    }

    public <T> T getReference(Class<T> arg0, Object arg1) {
        return (T)this.getPersistenceContext(false).getReference(arg0, arg1);
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Transaction management is not available for container managed EntityManagers");
    }

    public boolean isOpen() {
        return true;
    }

    public void joinTransaction() {
    }

    public void lock(Object arg0, LockModeType arg1) {
        this.getPersistenceContext(true).lock(arg0, arg1);
    }

    public <T> T merge(T arg0) {
        return (T)this.getPersistenceContext(true).merge(arg0);
    }

    public void persist(Object arg0) {
        this.getPersistenceContext(true).persist(arg0);
    }

    public void refresh(Object arg0) {
        this.getPersistenceContext(true).refresh(arg0);
    }

    public void remove(Object arg0) {
        this.getPersistenceContext(true).remove(arg0);
    }

    public void setFlushMode(FlushModeType arg0) {
        this.getPersistenceContext(false).setFlushMode(arg0);
    }

    public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
        return this.getPersistenceContext(false).createNamedQuery(arg0, arg1);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
        return this.getPersistenceContext(false).createQuery(arg0);
    }

    public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
        return this.getPersistenceContext(false).createQuery(arg0, arg1);
    }

    public void detach(Object arg0) {
        this.getPersistenceContext(false).detach(arg0);
    }

    public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
        return (T)this.getPersistenceContext(false).find(arg0, arg1, arg2);
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
        return (T)this.getPersistenceContext(arg2 != LockModeType.NONE).find(arg0, arg1, arg2);
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        return (T)this.getPersistenceContext(arg2 != LockModeType.NONE).find(arg0, arg1, arg2, arg3);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getPersistenceContext(false).getCriteriaBuilder();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public LockModeType getLockMode(Object arg0) {
        return this.getPersistenceContext(true).getLockMode(arg0);
    }

    public Metamodel getMetamodel() {
        return this.getPersistenceContext(false).getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.getPersistenceContext(false).getProperties();
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.getPersistenceContext(true).lock(arg0, arg1, arg2);
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
        this.getPersistenceContext(true).refresh(arg0, arg1);
    }

    public void refresh(Object arg0, LockModeType arg1) {
        this.getPersistenceContext(true).refresh(arg0, arg1);
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        this.getPersistenceContext(true).refresh(arg0, arg1, arg2);
    }

    public void setProperty(String arg0, Object arg1) {
        this.getPersistenceContext(false).setProperty(arg0, arg1);
    }

    public <T> T unwrap(Class<T> arg0) {
        return (T)this.getPersistenceContext(false).unwrap(arg0);
    }
}

