/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.component.dsl.OSGiResult;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.apache.aries.component.dsl.internal.UpdateSupport;
import org.osgi.framework.BundleContext;

public class CoalesceOSGiImpl<T>
extends OSGiImpl<T> {
    @SafeVarargs
    public CoalesceOSGiImpl(OSGi<T> ... programs) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            int i;
            AtomicBoolean initialized = new AtomicBoolean();
            AtomicInteger[] atomicIntegers = new AtomicInteger[programs.length];
            OSGiResult[] results = new OSGiResult[programs.length];
            AtomicInteger index = new AtomicInteger();
            Publisher[] publishers = new Publisher[programs.length];
            for (i = 0; i < atomicIntegers.length; ++i) {
                atomicIntegers[i] = new AtomicInteger();
            }
            for (i = 0; i < atomicIntegers.length; ++i) {
                AtomicInteger atomicInteger = atomicIntegers[i];
                int pos = i;
                publishers[i] = t -> {
                    OSGiResult result;
                    AtomicBoolean atomicBoolean = initialized;
                    synchronized (atomicBoolean) {
                        int indexInt;
                        atomicInteger.incrementAndGet();
                        if (initialized.get() && pos < (indexInt = index.getAndSet(pos))) {
                            for (int j = pos + 1; j <= indexInt; ++j) {
                                results[j].close();
                            }
                        }
                        result = op.publish(t);
                    }
                    return () -> {
                        AtomicBoolean atomicBoolean = initialized;
                        synchronized (atomicBoolean) {
                            result.close();
                            UpdateSupport.defer(() -> {
                                int current = atomicInteger.decrementAndGet();
                                if (!initialized.get()) {
                                    return;
                                }
                                if (pos <= index.get() && current == 0) {
                                    for (int j = pos + 1; j < results.length; ++j) {
                                        results[j] = programs[j].run(bundleContext, publishers[j]);
                                        index.set(j);
                                        if (atomicIntegers[j].get() > 0) break;
                                    }
                                }
                            });
                        }
                    };
                };
            }
            AtomicBoolean atomicBoolean = initialized;
            synchronized (atomicBoolean) {
                for (int i2 = 0; i2 < publishers.length; ++i2) {
                    results[i2] = programs[i2].run(bundleContext, publishers[i2]);
                    index.set(i2);
                    if (atomicIntegers[i2].get() <= 0) continue;
                    initialized.set(true);
                    break;
                }
                initialized.set(true);
            }
            return new OSGiResultImpl(() -> {
                AtomicBoolean atomicBoolean = initialized;
                synchronized (atomicBoolean) {
                    initialized.set(false);
                    for (int i = 0; i <= index.get(); ++i) {
                        results[i].close();
                    }
                }
            });
        });
    }
}

