/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.component.dsl.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.component.dsl.Publisher;
import org.apache.aries.component.dsl.internal.OSGiImpl;
import org.apache.aries.component.dsl.internal.OSGiResultImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;

public class ConfigurationOSGiImpl
extends OSGiImpl<Dictionary<String, ?>> {
    public ConfigurationOSGiImpl(final String pid) {
        super((BundleContext bundleContext, Publisher<T> op) -> {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            AtomicReference<Runnable> terminatorAtomicReference = new AtomicReference<Runnable>(() -> {});
            AtomicBoolean closed = new AtomicBoolean();
            ServiceRegistration serviceRegistration = bundleContext.registerService(ManagedService.class, properties -> {
                atomicReference.set(properties);
                ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
                if (properties != null) {
                    terminatorAtomicReference.set((Runnable)op.apply(properties));
                    if (closed.get()) {
                        ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
                        return;
                    }
                }
            }, (Dictionary)new Hashtable<String, Object>(){
                {
                    this.put("service.pid", pid);
                }
            });
            return new OSGiResultImpl(() -> {
                closed.set(true);
                serviceRegistration.unregister();
                ConfigurationOSGiImpl.signalLeave(terminatorAtomicReference);
            });
        });
    }

    private static void signalLeave(AtomicReference<Runnable> terminatorAtomicReference) {
        Runnable old = terminatorAtomicReference.getAndSet(null);
        if (old != null) {
            old.run();
        }
    }
}

