/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.spi.adapt;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.apache.aries.cdi.extension.spi.adapt.FiltersOn;
import org.apache.aries.cdi.extension.spi.adapt.ProcessPotentialService;

public class RegisterExtension {
    private final Extension extension;
    private final Collection<ObserverBuilder> builders = new ArrayList<ObserverBuilder>();

    public RegisterExtension(Extension extension) {
        this.extension = extension;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public Collection<ObserverBuilder> getBuilders() {
        return this.builders;
    }

    public ObserverBuilder registerObserver() {
        return new ObserverBuilder(this);
    }

    public static class ObserverBuilder {
        private final RegisterExtension parent;
        private List<Class<?>> types = new ArrayList<Class<FiltersOn>>(Collections.singletonList(FiltersOn.class));
        private List<Class<? extends Annotation>> annotations = new ArrayList<Class<FiltersOn>>(Collections.singletonList(FiltersOn.class));
        private BiConsumer<BeanManager, ProcessPotentialService> consumer;

        private ObserverBuilder(RegisterExtension parent) {
            this.parent = parent;
        }

        public ObserverBuilder forTypes(Class<?> ... types) {
            if (types.length > 0) {
                this.types.remove(FiltersOn.class);
            }
            this.types.addAll(Arrays.asList(types));
            return this;
        }

        public ObserverBuilder forAnnotations(Class<? extends Annotation> ... annotations) {
            if (annotations.length > 0) {
                this.annotations.remove(FiltersOn.class);
            }
            this.annotations.addAll(Arrays.asList(annotations));
            return this;
        }

        public ObserverBuilder execute(BiConsumer<BeanManager, ProcessPotentialService> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Collection<Class<?>> getTypes() {
            return Collections.unmodifiableList(this.types);
        }

        public Collection<Class<?>> getAnnotations() {
            return Collections.unmodifiableList(this.annotations);
        }

        public BiConsumer<BeanManager, ProcessPotentialService> getConsumer() {
            return this.consumer;
        }

        public RegisterExtension done() {
            if (this.consumer == null) {
                throw new IllegalArgumentException("No consumer registered on observer builder");
            }
            this.parent.builders.add(this);
            return this.parent;
        }
    }
}

