/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.servlet.weld;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Priority;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.aries.cdi.extension.servlet.common.BaseServletExtension;
import org.jboss.weld.module.web.servlet.WeldInitialListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WeldServletExtension
extends BaseServletExtension {
    private final BundleContext bundleContext;
    private static final String[] LISTENER_CLASSES = new String[]{ServletContextListener.class.getName(), ServletRequestListener.class.getName(), HttpSessionListener.class.getName()};

    protected WeldServletExtension() {
        this.bundleContext = null;
    }

    public WeldServletExtension(Bundle bundle) {
        this.bundleContext = bundle.getBundleContext();
    }

    void afterDeploymentValidation(@Observes @Priority(value=3800) AfterDeploymentValidation adv, BeanManager beanManager) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.description", "Aries CDI - HTTP Portable Extension for Weld");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)properties).put("osgi.http.whiteboard.context.select", this.configuration.get((Object)"osgi.http.whiteboard.context.select"));
        ((Dictionary)properties).put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
        ((Dictionary)properties).put("service.ranking", 2147483547);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(WeldInitialListener.class);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        Bean bean = beanManager.createBean(beanManager.createBeanAttributes(annotatedType), WeldInitialListener.class, injectionTargetFactory);
        WeldInitialListener initialListener = (WeldInitialListener)bean.create(beanManager.createCreationalContext((Contextual)bean));
        this._listenerRegistration = this.bundleContext.registerService(LISTENER_CLASSES, (Object)new ListenerWrapper(this, (HttpSessionListener)initialListener), properties);
    }

    private static class ListenerWrapper<T extends HttpSessionListener & ServletContextListener>
    implements HttpSessionListener,
    ServletContextListener,
    ServletRequestListener {
        private final T delegate;
        private final CountDownLatch latch = new CountDownLatch(1);
        final /* synthetic */ WeldServletExtension this$0;

        public ListenerWrapper(T delegate) {
            this.this$0 = var1_1;
            this.delegate = delegate;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            try {
                this.latch.await(20L, TimeUnit.SECONDS);
                ((ServletContextListener)this.delegate).contextDestroyed(sce);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.this$0.destroyed.set(true);
            }
        }

        public void contextInitialized(ServletContextEvent sce) {
            ((ServletContextListener)this.delegate).contextInitialized(sce);
            this.latch.countDown();
        }

        public void requestDestroyed(ServletRequestEvent sre) {
            try {
                this.latch.await(20L, TimeUnit.SECONDS);
                ((ServletRequestListener)this.delegate).requestDestroyed(sre);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void requestInitialized(ServletRequestEvent sre) {
            try {
                this.latch.await(20L, TimeUnit.SECONDS);
                ((ServletRequestListener)this.delegate).requestInitialized(sre);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void sessionCreated(HttpSessionEvent se) {
            try {
                this.latch.await(20L, TimeUnit.SECONDS);
                this.delegate.sessionCreated(se);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            try {
                this.latch.await(20L, TimeUnit.SECONDS);
                this.delegate.sessionDestroyed(se);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

