/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.servlet.common;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.aries.cdi.extension.spi.adapt.FiltersOn;
import org.apache.aries.cdi.extension.spi.adapt.MergeServiceTypes;
import org.apache.aries.cdi.extension.spi.adapt.ProcessPotentialService;
import org.apache.aries.cdi.extension.spi.adapt.RegisterExtension;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardContextSelect;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterAsyncSupported;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterDispatcher;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterName;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterPattern;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardFilterServlet;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardListener;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletAsyncSupported;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletMultipart;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletName;
import org.apache.aries.cdi.extra.propertytypes.HttpWhiteboardServletPattern;
import org.apache.aries.cdi.extra.propertytypes.ServiceDescription;
import org.apache.aries.cdi.extra.propertytypes.ServiceRanking;
import org.apache.aries.cdi.spi.configuration.Configuration;
import org.osgi.framework.ServiceRegistration;

public class BaseServletExtension
implements Extension {
    protected Configuration configuration;
    protected volatile ServiceRegistration<?> _listenerRegistration;
    protected final AtomicBoolean destroyed = new AtomicBoolean(false);

    void register(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        manager.fireEvent((Object)new RegisterExtension((Extension)this), new Annotation[0]);
    }

    void setConfiguration(@Observes Configuration configuration) {
        this.configuration = configuration;
    }

    void webFilter(@Observes @FiltersOn(annotations={WebFilter.class}) ProcessPotentialService pat, BeanManager beanManager) {
        beanManager.fireEvent((Object)MergeServiceTypes.forEvent((ProcessPotentialService)pat).withTypes(new Class[]{Filter.class}).build(), new Annotation[0]);
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        AnnotatedType annotatedType = pat.getAnnotatedType();
        WebFilter webFilter = (WebFilter)annotatedType.getAnnotation(WebFilter.class);
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            Optional.ofNullable((String)this.configuration.get((Object)"osgi.http.whiteboard.context.select")).ifPresent(select -> configurator.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)select)));
        }
        if (!annotatedType.isAnnotationPresent(ServiceDescription.class) && !webFilter.description().isEmpty()) {
            configurator.add((Annotation)ServiceDescription.Literal.of((String)webFilter.description()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardFilterName.class) && !webFilter.filterName().isEmpty()) {
            configurator.add((Annotation)HttpWhiteboardFilterName.Literal.of((String)webFilter.filterName()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardFilterServlet.class) && webFilter.servletNames().length > 0) {
            configurator.add((Annotation)HttpWhiteboardFilterServlet.Literal.of((String[])webFilter.servletNames()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardFilterPattern.class)) {
            if (webFilter.value().length > 0) {
                configurator.add((Annotation)HttpWhiteboardFilterPattern.Literal.of((String[])webFilter.value()));
            } else if (webFilter.urlPatterns().length > 0) {
                configurator.add((Annotation)HttpWhiteboardFilterPattern.Literal.of((String[])webFilter.urlPatterns()));
            }
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardFilterDispatcher.class) && webFilter.dispatcherTypes().length > 0) {
            configurator.add((Annotation)HttpWhiteboardFilterDispatcher.Literal.of((DispatcherType[])webFilter.dispatcherTypes()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardFilterAsyncSupported.class)) {
            configurator.add((Annotation)HttpWhiteboardFilterAsyncSupported.Literal.of((boolean)webFilter.asyncSupported()));
        }
    }

    void webListener(@Observes @FiltersOn(annotations={WebListener.class}) ProcessPotentialService pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        Class[] serviceTypes = (Class[])Stream.of(ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionAttributeListener.class, HttpSessionIdListener.class).filter(c -> c.isAssignableFrom(javaClass)).toArray(Class[]::new);
        beanManager.fireEvent((Object)MergeServiceTypes.forEvent((ProcessPotentialService)pat).withTypes(serviceTypes).build(), new Annotation[0]);
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        WebListener webListener = (WebListener)annotatedType.getAnnotation(WebListener.class);
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            Optional.ofNullable((String)this.configuration.get((Object)"osgi.http.whiteboard.context.select")).ifPresent(select -> configurator.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)select)));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardListener.class)) {
            configurator.add((Annotation)HttpWhiteboardListener.Literal.INSTANCE);
        }
        if (!annotatedType.isAnnotationPresent(ServiceDescription.class) && !webListener.value().isEmpty()) {
            configurator.add((Annotation)ServiceDescription.Literal.of((String)webListener.value()));
        }
    }

    void webServlet(@Observes @FiltersOn(annotations={WebServlet.class}) ProcessPotentialService pat, BeanManager beanManager) {
        MultipartConfig multipartConfig;
        beanManager.fireEvent((Object)MergeServiceTypes.forEvent((ProcessPotentialService)pat).withTypes(new Class[]{Servlet.class}).build(), new Annotation[0]);
        AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
        AnnotatedType annotatedType = pat.getAnnotatedType();
        WebServlet webServlet = (WebServlet)annotatedType.getAnnotation(WebServlet.class);
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardContextSelect.class)) {
            Optional.ofNullable((String)this.configuration.get((Object)"osgi.http.whiteboard.context.select")).ifPresent(select -> configurator.add((Annotation)HttpWhiteboardContextSelect.Literal.of((String)select)));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardServletName.class) && !webServlet.name().isEmpty()) {
            configurator.add((Annotation)HttpWhiteboardServletName.Literal.of((String)webServlet.name()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardServletPattern.class)) {
            if (webServlet.value().length > 0) {
                configurator.add((Annotation)HttpWhiteboardServletPattern.Literal.of((String[])webServlet.value()));
            } else if (webServlet.urlPatterns().length > 0) {
                configurator.add((Annotation)HttpWhiteboardServletPattern.Literal.of((String[])webServlet.urlPatterns()));
            }
        }
        if (!annotatedType.isAnnotationPresent(ServiceRanking.class)) {
            configurator.add((Annotation)ServiceRanking.Literal.of((int)webServlet.loadOnStartup()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardServletAsyncSupported.class)) {
            configurator.add((Annotation)HttpWhiteboardServletAsyncSupported.Literal.of((boolean)webServlet.asyncSupported()));
        }
        if (!annotatedType.isAnnotationPresent(ServiceDescription.class) && !webServlet.description().isEmpty()) {
            configurator.add((Annotation)ServiceDescription.Literal.of((String)webServlet.description()));
        }
        if (!annotatedType.isAnnotationPresent(HttpWhiteboardServletMultipart.class) && (multipartConfig = (MultipartConfig)annotatedType.getAnnotation(MultipartConfig.class)) != null) {
            configurator.add((Annotation)HttpWhiteboardServletMultipart.Literal.of((boolean)true, (int)multipartConfig.fileSizeThreshold(), (String)multipartConfig.location(), (long)multipartConfig.maxFileSize(), (long)multipartConfig.maxRequestSize()));
        }
    }

    void beforeShutdown(@Observes BeforeShutdown bs) {
        if (this._listenerRegistration != null && !this.destroyed.get()) {
            try {
                this._listenerRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

