/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.util.function.Predicate;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.cm.ConfigurationEvent;

public class Predicates {
    private Predicates() {
    }

    public static Predicate<ConfigurationTemplateDTO> isMatchingConfiguration(ConfigurationEvent event) {
        return new MatchingConfigurationPredicate(event);
    }

    private static class MatchingConfigurationPredicate
    implements Predicate<ConfigurationTemplateDTO> {
        private final ConfigurationEvent event;

        public MatchingConfigurationPredicate(ConfigurationEvent event) {
            this.event = event;
        }

        @Override
        public boolean test(ConfigurationTemplateDTO t) {
            if (t.pid == null) {
                return false;
            }
            return t.maximumCardinality == MaximumCardinality.MANY && t.pid.equals(this.event.getFactoryPid()) || t.maximumCardinality == MaximumCardinality.ONE && t.pid.equals(this.event.getPid());
        }
    }
}

