/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.aries.cdi.container.internal.bean.ReferenceBean;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentInstanceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.model.InstanceActivator;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.apache.aries.cdi.container.internal.util.SRs;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.log.Logger;

public class SingleActivator
extends InstanceActivator {
    private final Syncro _lock = new Syncro(true);
    private final Logger _log = this.containerState.containerLogs().getLogger(this.getClass());
    private volatile ServiceRegistration<?> serviceRegistration;

    private SingleActivator(Builder builder) {
        super(builder);
    }

    @Override
    public boolean close() {
        try (Syncro synchro = this._lock.open();){
            if (this.serviceRegistration != null) {
                this.serviceRegistration.unregister();
                this.serviceRegistration = null;
            }
            this._instance.activations.forEach(a -> {
                ExtendedActivationDTO extended = (ExtendedActivationDTO)((Object)a);
                Objects.requireNonNull(extended.onClose).accept(extended);
            });
            this._instance.activations.clear();
            this._instance.active = false;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op closeOp() {
        return Op.of(Op.Mode.CLOSE, Op.Type.SINGLE_ACTIVATOR, this._instance.ident());
    }

    @Override
    public boolean open() {
        try (Syncro synchro = this._lock.open();){
            if (this.containerState.bundleContext() == null) {
                boolean bl = false;
                return bl;
            }
            if (!this._instance.referencesResolved() || this._instance.active) {
                boolean bl = false;
                return bl;
            }
            final BeanManager beanManager = this.containerState.beanManager();
            if (beanManager == null) {
                boolean bl = false;
                return bl;
            }
            final ExtendedActivationTemplateDTO activationTemplate = (ExtendedActivationTemplateDTO)((Object)this._instance.template.activations.get(0));
            this._instance.template.references.stream().map(ExtendedReferenceTemplateDTO.class::cast).forEach(t -> this._instance.references.stream().filter(r -> r.template == t).findFirst().map(ExtendedReferenceDTO.class::cast).ifPresent(r -> {
                ReferenceBean bean = t.bean;
                bean.setBeanManager(beanManager);
                bean.setReferenceDTO((ExtendedReferenceDTO)((Object)((Object)r)));
            }));
            ExtendedComponentTemplateDTO extended = (ExtendedComponentTemplateDTO)this._instance.template;
            Set beans = beanManager.getBeans(extended.beanClass, extended.qualifiers.toArray(new Annotation[0]));
            final Bean bean = beanManager.resolve(beans);
            if (activationTemplate.serviceClasses.isEmpty()) {
                this.activate((Bean<? extends Object>)bean, activationTemplate, beanManager);
                this._log.debug(l -> l.debug("CCR `immediate component` {} activated on {}", (Object)this._instance.ident(), (Object)this.bundle()));
            } else if (activationTemplate.scope == ServiceScope.SINGLETON) {
                Map.Entry<ExtendedActivationDTO, Object> entry = this.activate((Bean<? extends Object>)bean, activationTemplate, beanManager);
                this.serviceRegistration = this.containerState.bundleContext().registerService(activationTemplate.serviceClasses.toArray(new String[0]), entry.getValue(), Maps.dict(this._instance.properties));
                entry.getKey().service = SRs.from(this.serviceRegistration.getReference());
                this._log.debug(l -> l.debug("CCR `singleton scope service` {} activated on {}", (Object)this._instance.ident(), (Object)this.bundle()));
            } else if (activationTemplate.scope == ServiceScope.BUNDLE) {
                this.serviceRegistration = this.containerState.bundleContext().registerService(activationTemplate.serviceClasses.toArray(new String[0]), (Object)new ServiceFactory(){
                    final Map<Object, ExtendedActivationDTO> _locals = new ConcurrentHashMap<Object, ExtendedActivationDTO>();

                    public Object getService(Bundle bundle, ServiceRegistration registration) {
                        Map.Entry<ExtendedActivationDTO, Object> entry = SingleActivator.this.activate((Bean<? extends Object>)bean, activationTemplate, beanManager);
                        entry.getKey().service = SRs.from(registration.getReference());
                        this._locals.put(entry.getValue(), entry.getKey());
                        return entry.getValue();
                    }

                    public void ungetService(Bundle bundle, ServiceRegistration registration, Object object) {
                        ExtendedActivationDTO activationDTO = this._locals.remove(object);
                        if (activationDTO != null) {
                            activationDTO.onClose.accept(activationDTO);
                        }
                    }
                }, Maps.dict(this._instance.properties));
                this._log.debug(l -> l.debug("CCR `bundle scope service` {} activated on {}", (Object)this._instance.ident(), (Object)this.bundle()));
            } else if (activationTemplate.scope == ServiceScope.PROTOTYPE) {
                this.serviceRegistration = this.containerState.bundleContext().registerService(activationTemplate.serviceClasses.toArray(new String[0]), (Object)new PrototypeServiceFactory(){
                    final Map<Object, ExtendedActivationDTO> _locals = new ConcurrentHashMap<Object, ExtendedActivationDTO>();

                    public Object getService(Bundle bundle, ServiceRegistration registration) {
                        Map.Entry<ExtendedActivationDTO, Object> entry = SingleActivator.this.activate((Bean<? extends Object>)bean, activationTemplate, beanManager);
                        entry.getKey().service = SRs.from(registration.getReference());
                        this._locals.put(entry.getValue(), entry.getKey());
                        return entry.getValue();
                    }

                    public void ungetService(Bundle bundle, ServiceRegistration registration, Object object) {
                        ExtendedActivationDTO activationDTO = this._locals.remove(object);
                        if (activationDTO != null) {
                            activationDTO.onClose.accept(activationDTO);
                        }
                    }
                }, Maps.dict(this._instance.properties));
                this._log.debug(l -> l.debug("CCR `prototype scope service` {} activated on {}", (Object)this._instance.ident(), (Object)this.bundle()));
            }
            this._instance.active = true;
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public Op openOp() {
        return Op.of(Op.Mode.OPEN, Op.Type.SINGLE_ACTIVATOR, this._instance.ident());
    }

    public String toString() {
        return Arrays.asList(this.getClass().getSimpleName(), this._instance.ident()).toString();
    }

    public static class Builder
    extends InstanceActivator.Builder<Builder> {
        private final Map<ExtendedComponentInstanceDTO, SingleActivator> _cache = new ConcurrentHashMap<ExtendedComponentInstanceDTO, SingleActivator>();

        public Builder(ContainerState containerState) {
            super(containerState, null);
        }

        @Override
        public InstanceActivator build() {
            return this._cache.computeIfAbsent(this._instance, i -> new SingleActivator(this));
        }
    }
}

