/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.aries.cdi.container.internal.util.Conversions;
import org.osgi.service.cdi.annotations.BeanPropertyType;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.TypeReference;

public class Maps {
    private Maps() {
    }

    public static void appendFilter(StringBuilder sb, Map<String, String> map) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("(");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append(")");
        }
    }

    public static <T> Stream<Map.Entry<String, T>> streamOf(Dictionary<String, T> dictionary) {
        return Collections.list(dictionary.keys()).stream().map(key -> new AbstractMap.SimpleEntry((String)key, dictionary.get(key)));
    }

    public static Map<String, Object> of(Dictionary<String, ?> dict) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Maps.streamOf(dict).forEach(e -> map.put((String)e.getKey(), e.getValue()));
        return map;
    }

    public static Dictionary<String, ?> dict(Map<String, Object> map) {
        Hashtable dict = new Hashtable();
        Objects.requireNonNull(map).forEach(dict::put);
        return dict;
    }

    public static Dictionary<String, ?> dict(Object ... args) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("requires even number of args");
        }
        for (int i = 0; i < args.length; i += 2) {
            ((Dictionary)map).put(String.valueOf(args[i]), args[i + 1]);
        }
        return map;
    }

    @SafeVarargs
    public static <T> Map<String, T> of(T ... args) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("requires even number of args");
        }
        for (int i = 0; i < args.length; i += 2) {
            map.put(String.valueOf(args[i]), args[i + 1]);
        }
        return map;
    }

    public static Map<String, Object> merge(Collection<Annotation> annotations) {
        return Maps.merge(annotations.stream().filter(ann -> Objects.nonNull(ann.annotationType().getAnnotation(BeanPropertyType.class))).map(ann -> (Map)((Converting)Conversions.convert(ann).sourceAs(ann.annotationType())).to((TypeReference)new TypeReference<Map<String, Object>>(){})).map(Map::entrySet).flatMap(Collection::stream));
    }

    public static Map<String, Object> merge(List<Dictionary<String, Object>> dictionaries) {
        return Maps.merge(dictionaries.stream().flatMap(Maps::streamOf));
    }

    @SafeVarargs
    public static Map<String, Object> merge(Map<String, Object> ... maps) {
        return Maps.merge(Arrays.stream(maps).map(Map::entrySet).flatMap(Collection::stream));
    }

    public static Map<String, Object> merge(Stream<Map.Entry<String, Object>> mapEntries) {
        return mapEntries.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Maps::mergeValues));
    }

    static Map<String, Object> addPrefix(Map<String, Object> map, String prefix) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> prefix + (String)e.getKey(), Map.Entry::getValue));
    }

    public static List<?> mergeValues(Object a, Object b) {
        List aList = (List)Conversions.convert(a).to(new TypeReference<List<?>>(){});
        List bList = (List)Conversions.convert(b).to(new TypeReference<List<?>>(){});
        List checkedList = Collections.checkedList(new ArrayList(), aList.get(0).getClass());
        checkedList.addAll(aList);
        checkedList.addAll(bList);
        return checkedList;
    }
}

