/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.aries.cdi.spi.loader.SpiLoader;
import org.osgi.framework.Bundle;

public final class BundleClassLoader
extends SpiLoader {
    private final Bundle _bundle;
    private final List<Bundle> _bundles = new CopyOnWriteArrayList<Bundle>();
    private final ConcurrentMap<String, Class<?>> _cache = new ConcurrentHashMap();
    private volatile Predicate<String> classPredicate;
    private volatile Function<String, Class<?>> classFunction;
    private volatile Function<String, Enumeration<URL>> resourceFunction;
    private volatile Predicate<String> resourcePredicate;

    public BundleClassLoader(Bundle cdiBundle, Bundle extenderBundle) {
        this._bundle = cdiBundle;
        this._bundles.add(Objects.requireNonNull(cdiBundle));
        this._bundles.add(Objects.requireNonNull(extenderBundle));
    }

    public Bundle getBundle() {
        return this._bundle;
    }

    public URL findResource(String name) {
        for (Bundle bundle : this.getBundles()) {
            URL url;
            if ((bundle.getState() & 1) == 1 || (url = bundle.getResource(name)) == null) continue;
            return url;
        }
        return null;
    }

    public Enumeration<URL> findResources(String name) {
        for (Bundle bundle : this.getBundles()) {
            if ((bundle.getState() & 1) == 1) continue;
            try {
                Enumeration enumeration = bundle.getResources(name);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    return enumeration;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.resourcePredicate == null || !this.resourcePredicate.test(name)) continue;
            return this.resourceFunction.apply(name);
        }
        return Collections.emptyEnumeration();
    }

    public List<Bundle> getBundles() {
        if (!this._bundles.contains(this._bundle)) {
            this._bundles.add(0, this._bundle);
        }
        return this._bundles;
    }

    public URL getResource(String name) {
        return this.findResource(name);
    }

    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    public BundleClassLoader handleResources(Predicate<String> predicate, Function<String, Enumeration<URL>> function) {
        this.resourcePredicate = Objects.requireNonNull(predicate);
        this.resourceFunction = Objects.requireNonNull(function);
        return this;
    }

    public BundleClassLoader findClass(Predicate<String> predicate, Function<String, Class<?>> function) {
        this.classPredicate = Objects.requireNonNull(predicate);
        this.classFunction = Objects.requireNonNull(function);
        return this;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Object classLoadingLock;
        Object object = classLoadingLock = this.getClassLoadingLock(name);
        synchronized (object) {
            for (Bundle bundle : this.getBundles()) {
                if ((bundle.getState() & 1) == 1) continue;
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
            if (this.classPredicate != null && this.classPredicate.test(name)) {
                return this.classFunction.apply(name);
            }
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object classLoadingLock;
        Object object = classLoadingLock = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = (Class<?>)this._cache.get(name);
            if (clazz == null) {
                clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                this._cache.put(name, clazz);
            }
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getOrRegister(String proxyClassName, byte[] proxyBytes, Package pck, ProtectionDomain protectionDomain) {
        String key = proxyClassName.replace('/', '.');
        Class existing = (Class)this._cache.get(key);
        if (existing == null) {
            Object classLoadingLock;
            Object object = classLoadingLock = this.getClassLoadingLock(key);
            synchronized (object) {
                existing = (Class)this._cache.get(key);
                if (existing == null) {
                    this.definePackageFor(pck, protectionDomain);
                    existing = super.defineClass(proxyClassName, proxyBytes, 0, proxyBytes.length);
                    this.resolveClass(existing);
                    this._cache.put(key, existing);
                }
            }
        }
        return existing;
    }

    private void definePackageFor(Package model, ProtectionDomain protectionDomain) {
        if (model == null) {
            return;
        }
        if (this.getPackage(model.getName()) == null) {
            if (model.isSealed() && protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
                this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), protectionDomain.getCodeSource().getLocation());
            } else {
                this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), null);
            }
        }
    }
}

