/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.container;

import aQute.lib.exceptions.Exceptions;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.aries.cdi.container.internal.annotated.AnnotatedTypeImpl;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.BeansModel;
import org.apache.aries.cdi.container.internal.model.ComponentPropertiesModel;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.OSGiBean;
import org.apache.aries.cdi.container.internal.model.ReferenceModel;
import org.apache.aries.cdi.container.internal.util.Annotates;
import org.apache.aries.cdi.container.internal.util.Reflection;
import org.osgi.service.cdi.ComponentType;
import org.osgi.service.cdi.ConfigurationPolicy;
import org.osgi.service.cdi.MaximumCardinality;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.cdi.annotations.ComponentProperties;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.FactoryComponent;
import org.osgi.service.cdi.annotations.PID;
import org.osgi.service.cdi.annotations.Reference;
import org.osgi.service.cdi.annotations.SingleComponent;
import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.cdi.reference.BindServiceReference;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Discovery {
    private static final List<Type> BIND_TYPES = Arrays.asList(BindService.class, BindBeanServiceObjects.class, BindServiceReference.class);
    static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final XPathFactory xpf = XPathFactory.newInstance();
    static final XPathExpression trimExpression;
    static final XPathExpression excludeExpression;
    private final BeansModel _beansModel;
    private final Set<OSGiBean> _componentScoped = new HashSet<OSGiBean>();
    private final ComponentTemplateDTO _containerTemplate;
    private final ContainerState _containerState;
    private final boolean _trim;
    private final List<Exclude> _excludes;

    public Discovery(ContainerState containerState) {
        this._containerState = containerState;
        this._beansModel = this._containerState.beansModel();
        this._containerTemplate = (ComponentTemplateDTO)this._containerState.containerDTO().template.components.get(0);
        AtomicBoolean trim = new AtomicBoolean();
        this._excludes = new ArrayList<Exclude>();
        this._beansModel.getBeansXml().stream().map(this::readXMLResource).forEach(doc -> {
            if (!trim.get()) {
                trim.set(this.checkTrim((Document)doc));
            }
            this._excludes.addAll(this.getExcludes((Document)doc));
        });
        this._trim = trim.get();
    }

    public void discover() {
        this._beansModel.getOSGiBeans().stream().forEach(osgiBean -> {
            osgiBean.found(true);
            AnnotatedTypeImpl annotatedType = new AnnotatedTypeImpl(osgiBean.getBeanClass());
            if (this.trimIt(annotatedType) || this.exclude(annotatedType)) {
                return;
            }
            try {
                String beanName = Annotates.beanName(annotatedType);
                Class<? extends Annotation> beanScope = Annotates.beanScope(annotatedType);
                Map<String, Object> componentProperties = Annotates.componentProperties(annotatedType);
                ServiceScope serviceScope = Annotates.serviceScope(annotatedType);
                List<String> serviceTypes = Annotates.serviceClassNames(annotatedType);
                if (annotatedType.isAnnotationPresent(SingleComponent.class)) {
                    this.doFactoryOrSingleComponent((OSGiBean)osgiBean, osgiBean.getBeanClass(), annotatedType, beanName, serviceTypes, serviceScope, componentProperties, ComponentType.SINGLE);
                } else if (annotatedType.isAnnotationPresent(FactoryComponent.class)) {
                    this.doFactoryOrSingleComponent((OSGiBean)osgiBean, osgiBean.getBeanClass(), annotatedType, beanName, serviceTypes, serviceScope, componentProperties, ComponentType.FACTORY);
                } else if (annotatedType.isAnnotationPresent(ComponentScoped.class)) {
                    this._componentScoped.add((OSGiBean)osgiBean);
                } else {
                    this.discoverActivations((OSGiBean)osgiBean, osgiBean.getBeanClass(), annotatedType, null, beanScope, serviceTypes, serviceScope, componentProperties);
                }
            }
            catch (Exception e) {
                this._containerState.error(e);
                return;
            }
            annotatedType.getConstructors().stream().filter(this::isInject).flatMap(annotatedConstructor -> annotatedConstructor.getParameters().stream()).forEach(annotatedParameter -> this.processAnnotated((Annotated)annotatedParameter, annotatedParameter.getBaseType(), Annotates.qualifiers((Annotated)annotatedParameter), (OSGiBean)osgiBean));
            annotatedType.getFields().stream().filter(this::isInject).forEach(annotatedField -> this.processAnnotated((Annotated)annotatedField, annotatedField.getBaseType(), Annotates.qualifiers((Annotated)annotatedField), (OSGiBean)osgiBean));
            annotatedType.getFields().stream().filter(this::isProduces).forEach(annotatedField -> {
                Class<? extends Annotation> beanScope = Annotates.beanScope((Annotated)annotatedField);
                Map<String, Object> componentProperties = Annotates.componentProperties((Annotated)annotatedField);
                ServiceScope serviceScope = Annotates.serviceScope((Annotated)annotatedField);
                List<String> serviceTypes = Annotates.serviceClassNames((Annotated)annotatedField);
                this.discoverActivations((OSGiBean)osgiBean, osgiBean.getBeanClass(), (Annotated)annotatedField, (AnnotatedMember<?>)annotatedField, beanScope, serviceTypes, serviceScope, componentProperties);
            });
            annotatedType.getMethods().stream().forEach(annotatedMethod -> {
                if (this.isInjectOrProduces((AnnotatedMember)annotatedMethod)) {
                    annotatedMethod.getParameters().stream().forEach(annotatedParameter -> this.processAnnotated((Annotated)annotatedParameter, annotatedParameter.getBaseType(), Annotates.qualifiers((Annotated)annotatedParameter), (OSGiBean)osgiBean));
                    if (this.isProduces((AnnotatedMember)annotatedMethod)) {
                        Class<? extends Annotation> beanScope = Annotates.beanScope((Annotated)annotatedMethod);
                        Map<String, Object> componentProperties = Annotates.componentProperties((Annotated)annotatedMethod);
                        ServiceScope serviceScope = Annotates.serviceScope((Annotated)annotatedMethod);
                        List<String> serviceTypes = Annotates.serviceClassNames((Annotated)annotatedMethod);
                        this.discoverActivations((OSGiBean)osgiBean, osgiBean.getBeanClass(), (Annotated)annotatedMethod, (AnnotatedMember<?>)annotatedMethod, beanScope, serviceTypes, serviceScope, componentProperties);
                    }
                } else if (this.isDisposeOrObserves((AnnotatedMethod)annotatedMethod)) {
                    annotatedMethod.getParameters().subList(1, annotatedMethod.getParameters().size()).stream().forEach(annotatedParameter -> this.processAnnotated((Annotated)annotatedParameter, annotatedParameter.getBaseType(), Annotates.qualifiers((Annotated)annotatedParameter), (OSGiBean)osgiBean));
                }
            });
        });
        this.postProcessComponentScopedBeans();
    }

    boolean exclude(AnnotatedType<?> annotatedType) {
        return this._excludes.stream().anyMatch(ex -> ex.exclude(annotatedType));
    }

    boolean trimIt(AnnotatedType<?> annotatedType) {
        if (!this._trim) {
            return false;
        }
        if (Annotates.hasBeanDefiningAnnotations(annotatedType)) {
            return false;
        }
        return Annotates.beanScope(annotatedType, null) == null;
    }

    <X> boolean isInject(AnnotatedMember<X> annotatedMember) {
        return annotatedMember.isAnnotationPresent(Inject.class) && !annotatedMember.isStatic();
    }

    <X> boolean isInjectOrProduces(AnnotatedMember<X> annotatedMember) {
        return annotatedMember.isAnnotationPresent(Inject.class) && !annotatedMember.isStatic() || annotatedMember.isAnnotationPresent(Produces.class);
    }

    <X> boolean isProduces(AnnotatedMember<X> annotatedMember) {
        return annotatedMember.isAnnotationPresent(Produces.class);
    }

    <X> boolean isDisposeOrObserves(AnnotatedMethod<X> annotatedMethod) {
        return !annotatedMethod.getParameters().isEmpty() && (((AnnotatedParameter)annotatedMethod.getParameters().get(0)).isAnnotationPresent(Disposes.class) || ((AnnotatedParameter)annotatedMethod.getParameters().get(0)).isAnnotationPresent(Observes.class) || ((AnnotatedParameter)annotatedMethod.getParameters().get(0)).isAnnotationPresent(ObservesAsync.class));
    }

    <X> void processAnnotated(Annotated annotated, Type injectionPointType, Set<Annotation> qualifiers, OSGiBean osgiBean) {
        if (BIND_TYPES.contains(Reflection.getRawType(annotated.getBaseType()))) {
            ReferenceModel.Builder builder = new ReferenceModel.Builder(annotated);
            try {
                ReferenceModel referenceModel = builder.type(injectionPointType).build();
                osgiBean.addReference(referenceModel.toDTO());
            }
            catch (Exception e) {
                this._containerState.error(e);
            }
        } else {
            Reference reference = (Reference)annotated.getAnnotation(Reference.class);
            ComponentProperties componentProperties = (ComponentProperties)annotated.getAnnotation(ComponentProperties.class);
            if (reference != null) {
                this.doReference(osgiBean, annotated, injectionPointType, reference, componentProperties);
            } else if (componentProperties != null) {
                this.doComponentProperties(osgiBean, injectionPointType, qualifiers);
            }
        }
    }

    void postProcessComponentScopedBeans() {
        this._containerState.containerDTO().template.components.stream().filter(template -> template.type != ComponentType.CONTAINER).map(template -> (ExtendedComponentTemplateDTO)((Object)template)).forEach(template -> this._componentScoped.forEach(osgiBean -> {
            String className;
            if (osgiBean.getComponent() == null) {
                osgiBean.setComponent(this._containerState, (ComponentTemplateDTO)template);
            }
            if (!template.beans.contains(className = osgiBean.getBeanClass().getName())) {
                template.beans.add(className);
            }
        }));
    }

    void doComponentProperties(OSGiBean osgiBean, Type injectionPointType, Set<Annotation> qualifiers) {
        try {
            ComponentPropertiesModel configurationModel = new ComponentPropertiesModel.Builder(injectionPointType).declaringClass(osgiBean.getBeanClass()).qualifiers(qualifiers).build();
            osgiBean.addConfiguration(this._containerState, configurationModel.toDTO());
        }
        catch (Exception e) {
            this._containerState.error(e);
        }
    }

    void discoverActivations(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, AnnotatedMember<?> producer, Class<? extends Annotation> scope, List<String> serviceTypeNames, ServiceScope serviceScope, Map<String, Object> componentProperties) {
        String className = declaringClass.getName();
        if (!this._containerTemplate.beans.contains(className)) {
            this._containerTemplate.beans.add(className);
        }
        if (!serviceTypeNames.isEmpty()) {
            if (!scope.equals(ApplicationScoped.class) && !scope.equals(Dependent.class)) {
                this._containerState.error(new IllegalStateException(String.format("@Service can only be used on @ApplicationScoped, @Dependent, @SingleComponent, and @FactoryComponent: %s", osgiBean.getBeanClass())));
                return;
            }
            ExtendedActivationTemplateDTO activationTemplate = new ExtendedActivationTemplateDTO();
            activationTemplate.cdiScope = scope;
            activationTemplate.declaringClass = declaringClass;
            activationTemplate.producer = producer;
            activationTemplate.properties = componentProperties;
            activationTemplate.scope = serviceScope;
            activationTemplate.serviceClasses = serviceTypeNames;
            this._containerTemplate.activations.add(activationTemplate);
        }
        osgiBean.setComponent(this._containerState, this._containerTemplate);
    }

    void doFactoryOrSingleComponent(OSGiBean osgiBean, Class<?> declaringClass, Annotated annotated, String beanName, List<String> serviceTypes, ServiceScope serviceScope, Map<String, Object> componentProperties, ComponentType componentType) {
        Set<Annotation> qualifiers = Annotates.qualifiers(annotated);
        qualifiers.removeIf(Named.class::isInstance);
        ExtendedComponentTemplateDTO componentTemplate = new ExtendedComponentTemplateDTO();
        componentTemplate.activations = new CopyOnWriteArrayList();
        ExtendedActivationTemplateDTO activationTemplate = new ExtendedActivationTemplateDTO();
        activationTemplate.declaringClass = declaringClass;
        activationTemplate.properties = Collections.emptyMap();
        activationTemplate.scope = serviceScope;
        activationTemplate.serviceClasses = serviceTypes;
        componentTemplate.activations.add(activationTemplate);
        componentTemplate.beanClass = declaringClass;
        componentTemplate.qualifiers = qualifiers;
        componentTemplate.beans = new CopyOnWriteArrayList();
        componentTemplate.configurations = new CopyOnWriteArrayList();
        componentTemplate.name = beanName;
        componentTemplate.properties = componentProperties;
        componentTemplate.references = new CopyOnWriteArrayList();
        componentTemplate.type = componentType;
        annotated.getAnnotations(PID.class).stream().forEach(PID2 -> {
            String pid = PID2.value();
            ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
            configurationTemplate.declaringClass = declaringClass;
            configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
            configurationTemplate.pid = Optional.of(pid).map(s -> s.equals("$") || s.equals("") ? componentTemplate.name : s).orElse(componentTemplate.name);
            if (componentType == ComponentType.SINGLE) {
                configurationTemplate.pid = pid.equals("$") || pid.equals("") ? componentTemplate.name : pid;
            }
            configurationTemplate.policy = PID2.policy();
            componentTemplate.configurations.add(configurationTemplate);
        });
        if (componentType == ComponentType.SINGLE) {
            if (componentTemplate.configurations.isEmpty()) {
                ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
                configurationTemplate.declaringClass = declaringClass;
                configurationTemplate.maximumCardinality = MaximumCardinality.ONE;
                configurationTemplate.pid = componentTemplate.name;
                configurationTemplate.policy = ConfigurationPolicy.OPTIONAL;
                componentTemplate.configurations.add(configurationTemplate);
            }
        } else {
            ExtendedConfigurationTemplateDTO configurationTemplate = new ExtendedConfigurationTemplateDTO();
            configurationTemplate.declaringClass = declaringClass;
            configurationTemplate.maximumCardinality = MaximumCardinality.MANY;
            configurationTemplate.pid = Optional.ofNullable(annotated.getAnnotation(FactoryComponent.class)).map(FactoryComponent::value).map(v -> v.equals("$") || v.equals("") ? componentTemplate.name : v).orElse(componentTemplate.name);
            configurationTemplate.policy = ConfigurationPolicy.REQUIRED;
            componentTemplate.configurations.add(configurationTemplate);
        }
        componentTemplate.beans.add(declaringClass.getName());
        this._containerState.containerDTO().template.components.add(componentTemplate);
        osgiBean.setComponent(this._containerState, componentTemplate);
    }

    void doReference(OSGiBean osgiBean, Annotated annotated, Type injectionPointType, Reference reference, ComponentProperties componentProperties) {
        if (componentProperties != null) {
            this._containerState.error(new IllegalArgumentException(String.format("Cannot use @Reference and @Configuration on the same injection point {}", injectionPointType)));
            return;
        }
        ReferenceModel.Builder builder = null;
        builder = annotated instanceof AnnotatedParameter ? new ReferenceModel.Builder(annotated) : new ReferenceModel.Builder(annotated);
        try {
            ReferenceModel referenceModel = builder.type(injectionPointType).build();
            osgiBean.addReference(referenceModel.toDTO());
        }
        catch (Exception e) {
            this._containerState.error(e);
        }
    }

    boolean checkTrim(Document document) {
        try {
            return (Boolean)Boolean.class.cast(trimExpression.evaluate(document, XPathConstants.BOOLEAN));
        }
        catch (XPathExpressionException e) {
            throw Exceptions.duck(e);
        }
    }

    List<Exclude> getExcludes(Document document) {
        try {
            ArrayList<Exclude> excludes = new ArrayList<Exclude>();
            NodeList excludeNodes = (NodeList)NodeList.class.cast(excludeExpression.evaluate(document, XPathConstants.NODESET));
            for (int i = 0; i < excludeNodes.getLength(); ++i) {
                Element excludeElement = (Element)excludeNodes.item(i);
                excludes.add(new Exclude(excludeElement));
            }
            return excludes;
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document readXMLResource(URL resource) {
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            try (InputStream is = resource.openStream();){
                Document document = db.parse(is);
                return document;
            }
            catch (Throwable t) {
                return db.newDocument();
            }
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    static {
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            XPath xPath = xpf.newXPath();
            trimExpression = xPath.compile("boolean(/beans/trim)");
            excludeExpression = xPath.compile("/beans/scan/exclude");
        }
        catch (Throwable t) {
            throw Exceptions.duck(t);
        }
    }

    class Exclude {
        private final String name;
        private final Match match;
        private final List<String> ifClassAvailableS = new ArrayList<String>();
        private final List<String> ifClassesNotAvailableS = new ArrayList<String>();
        private final Map<String, String> ifSystemPropertyS = new HashMap<String, String>();

        public Exclude(Element excludeElement) {
            String glob = excludeElement.getAttribute("name");
            if (glob.endsWith(".**")) {
                this.match = Match.PACKAGE_PREFIX;
                this.name = glob.substring(0, glob.length() - 3);
            } else if (glob.endsWith(".*")) {
                this.match = Match.PACKAGE_NAME;
                this.name = glob.substring(0, glob.length() - 2);
            } else {
                this.match = Match.CLASSNAME;
                this.name = glob;
            }
            NodeList ifClassAvailableNodes = excludeElement.getElementsByTagName("if-class-available");
            for (int iCAIdx = 0; iCAIdx < ifClassAvailableNodes.getLength(); ++iCAIdx) {
                Element ifClassAvailableElement = (Element)ifClassAvailableNodes.item(iCAIdx);
                Attr nameAttribute = ifClassAvailableElement.getAttributeNode("name");
                this.ifClassAvailableS.add(nameAttribute.getValue());
            }
            NodeList ifClassNotAvailableNodes = excludeElement.getElementsByTagName("if-class-not-available");
            for (int iCNAIdx = 0; iCNAIdx < ifClassNotAvailableNodes.getLength(); ++iCNAIdx) {
                Element ifClassNotAvailableElement = (Element)ifClassNotAvailableNodes.item(iCNAIdx);
                Attr nameAttribute = ifClassNotAvailableElement.getAttributeNode("name");
                this.ifClassesNotAvailableS.add(nameAttribute.getValue());
            }
            NodeList ifSystemPropertyNodes = excludeElement.getElementsByTagName("if-system-property");
            for (int iCNAIdx = 0; iCNAIdx < ifSystemPropertyNodes.getLength(); ++iCNAIdx) {
                Element ifSystemPropertyElement = (Element)ifSystemPropertyNodes.item(iCNAIdx);
                String value = "";
                if (ifSystemPropertyElement.hasAttribute("value")) {
                    value = ifSystemPropertyElement.getAttributeNode("value").getValue();
                }
                Attr nameAttribute = ifSystemPropertyElement.getAttributeNode("name");
                this.ifSystemPropertyS.put(nameAttribute.getValue(), value);
            }
        }

        public boolean exclude(AnnotatedType<?> annotatedType) {
            String className = annotatedType.getJavaClass().getName();
            String packageName = annotatedType.getJavaClass().getPackage().getName();
            boolean matches = false;
            switch (this.match) {
                case CLASSNAME: {
                    matches = className.equals(this.name);
                    break;
                }
                case PACKAGE_NAME: {
                    matches = packageName.equals(this.name);
                    break;
                }
                case PACKAGE_PREFIX: {
                    matches = packageName.startsWith(this.name);
                }
            }
            return matches && this.ifClassAvailableS.stream().allMatch(this::classIsAvailable) && this.ifClassesNotAvailableS.stream().allMatch(this::classIsNotAvailable) && this.ifSystemPropertyS.entrySet().stream().allMatch(this::isPropertySet);
        }

        boolean classIsNotAvailable(String className) {
            return !this.classIsAvailable(className);
        }

        boolean classIsAvailable(String className) {
            try {
                Class.forName(className, false, (ClassLoader)((Object)Discovery.this._containerState.classLoader()));
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                return false;
            }
        }

        boolean isPropertySet(Map.Entry<String, String> entry) {
            if (entry.getValue().isEmpty()) {
                return Discovery.this._containerState.bundleContext().getProperty(entry.getKey()) != null;
            }
            return entry.getValue().equals(Discovery.this._containerState.bundleContext().getProperty(entry.getKey()));
        }

        public String toString() {
            return this.name + ":" + (Object)((Object)this.match);
        }
    }

    static enum Match {
        CLASSNAME,
        PACKAGE_NAME,
        PACKAGE_PREFIX;

    }
}

