/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.ConverterBuilder;
import org.osgi.util.converter.ConverterBuilderImpl;
import org.osgi.util.converter.ConvertingImpl;
import org.osgi.util.converter.Functioning;
import org.osgi.util.converter.FunctioningImpl;
import org.osgi.util.converter.InternalConverter;
import org.osgi.util.converter.InternalConverting;
import org.osgi.util.converter.Rule;
import org.osgi.util.converter.TypeRule;
import org.osgi.util.function.Function;

class ConverterImpl
implements InternalConverter {
    static final SimpleDateFormat ISO8601_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    ConverterImpl() {
    }

    @Override
    public InternalConverting convert(Object obj) {
        return new ConvertingImpl(this, obj);
    }

    @Override
    public Functioning function() {
        return new FunctioningImpl(this);
    }

    void addStandardRules(ConverterBuilder cb) {
        cb.rule(new Rule<Calendar, String>((Function)new Function<Calendar, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String apply(Calendar f) {
                SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    return ISO8601_DATE_FORMAT.format(f.getTime());
                }
            }
        }){});
        cb.rule(new Rule<String, Calendar>((Function)new Function<String, Calendar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Calendar apply(String f) {
                try {
                    SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
                    synchronized (simpleDateFormat) {
                        Calendar cc = Calendar.getInstance();
                        cc.setTime(ISO8601_DATE_FORMAT.parse(f));
                        return cc;
                    }
                }
                catch (ParseException e) {
                    throw new ConversionException("Cannot convert " + f + " to Date", e);
                }
            }
        }){});
        cb.rule(new Rule<Calendar, Long>((Function)new Function<Calendar, Long>(){

            public Long apply(Calendar f) {
                return f.getTime().getTime();
            }
        }){});
        cb.rule(new Rule<Long, Calendar>((Function)new Function<Long, Calendar>(){

            public Calendar apply(Long f) {
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(f);
                return c;
            }
        }){});
        cb.rule(new Rule<Character, Boolean>((Function)new Function<Character, Boolean>(){

            public Boolean apply(Character c) {
                return c.charValue() != '\u0000';
            }
        }){});
        cb.rule(new Rule<Boolean, Character>((Function)new Function<Boolean, Character>(){

            public Character apply(Boolean b) {
                return Character.valueOf(b != false ? (char)'\u0001' : '\u0000');
            }
        }){});
        cb.rule(new Rule<Character, Integer>((Function)new Function<Character, Integer>(){

            public Integer apply(Character c) {
                return c.charValue();
            }
        }){});
        cb.rule(new Rule<Character, Long>((Function)new Function<Character, Long>(){

            public Long apply(Character c) {
                return c.charValue();
            }
        }){});
        cb.rule(new Rule<String, Character>((Function)new Function<String, Character>(){

            public Character apply(String f) {
                return Character.valueOf(f.length() > 0 ? f.charAt(0) : (char)'\u0000');
            }
        }){});
        cb.rule(new Rule<String, Class<?>>(new Function<String, Class<?>>(){

            public Class<?> apply(String cn) {
                return ConverterImpl.this.loadClassUnchecked(cn);
            }
        }){});
        cb.rule(new Rule<Date, Long>((Function)new Function<Date, Long>(){

            public Long apply(Date d) {
                return d.getTime();
            }
        }){});
        cb.rule(new Rule<Long, Date>((Function)new Function<Long, Date>(){

            public Date apply(Long f) {
                return new Date(f);
            }
        }){});
        cb.rule(new Rule<Date, String>((Function)new Function<Date, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String apply(Date d) {
                SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    return ISO8601_DATE_FORMAT.format(d);
                }
            }
        }){});
        cb.rule(new Rule<String, Date>((Function)new Function<String, Date>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Date apply(String f) {
                try {
                    SimpleDateFormat simpleDateFormat = ISO8601_DATE_FORMAT;
                    synchronized (simpleDateFormat) {
                        return ISO8601_DATE_FORMAT.parse(f);
                    }
                }
                catch (ParseException e) {
                    throw new ConversionException("Cannot convert " + f + " to Date", e);
                }
            }
        }){});
        cb.rule(new Rule<String, Pattern>((Function)new Function<String, Pattern>(){

            public Pattern apply(String ps) {
                return Pattern.compile(ps);
            }
        }){});
        cb.rule(new Rule<String, UUID>((Function)new Function<String, UUID>(){

            public UUID apply(String uuid) {
                return UUID.fromString(uuid);
            }
        }){});
        cb.rule(new Rule<char[], String>((Function)new Function<char[], String>(){

            public String apply(char[] ca) {
                return ConverterImpl.this.charArrayToString(ca);
            }
        }){});
        cb.rule(new Rule<Character[], String>((Function)new Function<Character[], String>(){

            public String apply(Character[] ca) {
                return ConverterImpl.this.characterArrayToString(ca);
            }
        }){});
        cb.rule(new Rule<String, char[]>((Function)new Function<String, char[]>(){

            public char[] apply(String s) {
                return ConverterImpl.this.stringToCharArray(s);
            }
        }){});
        cb.rule(new Rule<String, Character[]>((Function)new Function<String, Character[]>(){

            public Character[] apply(String s) {
                return ConverterImpl.this.stringToCharacterArray(s);
            }
        }){});
        cb.rule(new Rule<Number, Boolean>((Function)new Function<Number, Boolean>(){

            public Boolean apply(Number obj) {
                return obj.longValue() != 0L;
            }
        }){});
        cb.rule(new Rule<Number, Character>((Function)new Function<Number, Character>(){

            public Character apply(Number obj) {
                return Character.valueOf((char)obj.intValue());
            }
        }){});
        this.reflectiveAddJavaTimeRule(cb, "java.time.LocalDateTime");
        this.reflectiveAddJavaTimeRule(cb, "java.time.LocalDate");
        this.reflectiveAddJavaTimeRule(cb, "java.time.LocalTime");
        this.reflectiveAddJavaTimeRule(cb, "java.time.OffsetDateTime");
        this.reflectiveAddJavaTimeRule(cb, "java.time.OffsetTime");
        this.reflectiveAddJavaTimeRule(cb, "java.time.ZonedDateTime");
    }

    private void reflectiveAddJavaTimeRule(ConverterBuilder cb, String timeClsName) {
        try {
            final Class<?> toCls = this.getClass().getClassLoader().loadClass(timeClsName);
            final Method toMethod = toCls.getMethod("parse", CharSequence.class);
            cb.rule(new TypeRule<String, Object>((Type)((Object)String.class), toCls, new Function<String, Object>(){

                public Object apply(String f) {
                    try {
                        return toMethod.invoke(null, f);
                    }
                    catch (Exception e) {
                        throw new ConversionException("Problem converting to " + toCls, e);
                    }
                }
            }));
            cb.rule(new TypeRule<Object, String>(toCls, (Type)((Object)String.class), new Function<Object, String>(){

                public String apply(Object t) {
                    return t.toString();
                }
            }));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String charArrayToString(char[] ca) {
        StringBuilder sb = new StringBuilder(ca.length);
        for (char c : ca) {
            sb.append(c);
        }
        return sb.toString();
    }

    String characterArrayToString(Character[] ca) {
        return this.charArrayToString(this.convert(ca).to(char[].class));
    }

    char[] stringToCharArray(String s) {
        char[] ca = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            ca[i] = s.charAt(i);
        }
        return ca;
    }

    Character[] stringToCharacterArray(String s) {
        return this.convert(this.stringToCharArray(s)).to(Character[].class);
    }

    Class<?> loadClassUnchecked(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(className);
        }
    }

    @Override
    public ConverterBuilderImpl newConverterBuilder() {
        return new ConverterBuilderImpl(this);
    }

    static {
        ISO8601_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

