/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.util;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.ProcessSyntheticBean;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.jboss.weld.util.Types;
import org.osgi.service.cdi.ServiceScope;
import org.osgi.service.cdi.annotations.Service;
import org.osgi.service.cdi.annotations.ServiceInstance;

public class Annotates {
    private Annotates() {
    }

    public static Map<String, Object> componentProperties(Annotated annotated) {
        return Maps.merge(annotated.getAnnotations());
    }

    public static <X> Class<X> declaringClass(Object instance) {
        Class declaringClass = null;
        if (instance instanceof AnnotatedMember) {
            AnnotatedMember af = (AnnotatedMember)instance;
            declaringClass = af.getDeclaringType().getJavaClass();
        } else if (instance instanceof AnnotatedParameter) {
            AnnotatedParameter ap = (AnnotatedParameter)instance;
            Parameter javaParameter = ap.getJavaParameter();
            Executable executable = javaParameter.getDeclaringExecutable();
            declaringClass = executable.getDeclaringClass();
        } else if (instance instanceof javax.enterprise.inject.spi.AnnotatedType) {
            javax.enterprise.inject.spi.AnnotatedType annotatedType = (javax.enterprise.inject.spi.AnnotatedType)instance;
            declaringClass = annotatedType.getJavaClass();
        } else if (instance instanceof Annotated) {
            Annotated annotated = (Annotated)instance;
            declaringClass = Types.getRawTypes((Type[])new Type[]{annotated.getBaseType()})[0];
        } else if (instance instanceof ProcessManagedBean) {
            ProcessManagedBean bean = (ProcessManagedBean)instance;
            declaringClass = bean.getAnnotatedBeanClass().getJavaClass();
        } else if (instance instanceof ProcessSessionBean) {
            ProcessSessionBean bean = (ProcessSessionBean)instance;
            declaringClass = bean.getAnnotatedBeanClass().getJavaClass();
        } else if (instance instanceof ProcessProducerMethod) {
            ProcessProducerMethod producer = (ProcessProducerMethod)instance;
            declaringClass = producer.getAnnotatedProducerMethod().getDeclaringType().getJavaClass();
        } else if (instance instanceof ProcessProducerField) {
            ProcessProducerField producer = (ProcessProducerField)instance;
            declaringClass = producer.getAnnotatedProducerField().getDeclaringType().getJavaClass();
        } else if (instance instanceof ProcessSyntheticBean) {
            ProcessSyntheticBean synthetic = (ProcessSyntheticBean)instance;
            declaringClass = synthetic.getBean().getBeanClass();
        } else if (instance instanceof ProcessBean) {
            ProcessBean processBean = (ProcessBean)instance;
            declaringClass = processBean.getBean().getBeanClass();
        }
        return declaringClass;
    }

    public static List<Class<?>> serviceClasses(Annotated annotated) {
        ArrayList serviceTypes = new ArrayList();
        ArrayList<AnnotatedType> ats = new ArrayList<AnnotatedType>();
        if (annotated instanceof javax.enterprise.inject.spi.AnnotatedType) {
            Class annotatedClass = ((javax.enterprise.inject.spi.AnnotatedType)annotated).getJavaClass();
            Optional.ofNullable(annotatedClass.getAnnotatedSuperclass()).ifPresent(at -> ats.add((AnnotatedType)at));
            ats.addAll(Arrays.asList(annotatedClass.getAnnotatedInterfaces()));
            for (AnnotatedType at2 : ats) {
                Optional.ofNullable(at2.getAnnotation(Service.class)).ifPresent(service -> {
                    if (service.value().length > 0) {
                        throw new IllegalArgumentException(String.format("@Service on type_use must not specify a value: %s", annotatedClass));
                    }
                    Type type = at2.getType();
                    if (!(type instanceof Class)) {
                        throw new IllegalArgumentException(String.format("@Service on type_use must only be specified on non-generic types: %s", annotatedClass));
                    }
                    serviceTypes.add((Class)type);
                });
            }
            Service service2 = (Service)annotated.getAnnotation(Service.class);
            if (service2 == null) {
                return serviceTypes;
            }
            if (!serviceTypes.isEmpty()) {
                throw new IllegalArgumentException(String.format("@Service must not be applied to type and type_use: %s", annotated));
            }
            if (service2.value().length > 0) {
                serviceTypes.addAll(Arrays.asList(service2.value()));
            } else if (annotatedClass.getInterfaces().length > 0) {
                serviceTypes.addAll(Arrays.asList(annotatedClass.getInterfaces()));
            } else {
                serviceTypes.add(annotatedClass);
            }
        } else if (annotated instanceof AnnotatedMethod) {
            Service service3 = (Service)annotated.getAnnotation(Service.class);
            if (service3 == null) {
                return serviceTypes;
            }
            Class<?> returnType = ((AnnotatedMethod)annotated).getJavaMember().getReturnType();
            if (service3.value().length > 0) {
                serviceTypes.addAll(Arrays.asList(service3.value()));
            } else if (returnType.getInterfaces().length > 0) {
                serviceTypes.addAll(Arrays.asList(returnType.getInterfaces()));
            } else {
                serviceTypes.add(returnType);
            }
        } else if (annotated instanceof AnnotatedField) {
            Service service4 = (Service)annotated.getAnnotation(Service.class);
            if (service4 == null) {
                return serviceTypes;
            }
            Class<?> fieldType = ((AnnotatedField)annotated).getJavaMember().getType();
            if (service4.value().length > 0) {
                serviceTypes.addAll(Arrays.asList(service4.value()));
            } else if (fieldType.getInterfaces().length > 0) {
                serviceTypes.addAll(Arrays.asList(fieldType.getInterfaces()));
            } else {
                serviceTypes.add(fieldType);
            }
        }
        return serviceTypes;
    }

    public static List<String> serviceClassNames(Annotated annotated) {
        return Annotates.serviceClasses(annotated).stream().map(st -> st.getName()).sorted().collect(Collectors.toList());
    }

    public static ServiceScope serviceScope(Annotated annotated) {
        ServiceInstance serviceInstance = (ServiceInstance)annotated.getAnnotation(ServiceInstance.class);
        if (serviceInstance != null) {
            return serviceInstance.value();
        }
        return ServiceScope.SINGLETON;
    }
}

