/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.aries.cdi.container.internal.CCR;
import org.apache.aries.cdi.container.internal.ChangeCount;
import org.apache.aries.cdi.container.internal.command.CDICommand;
import org.apache.aries.cdi.container.internal.container.CDIBundle;
import org.apache.aries.cdi.container.internal.container.ConfigurationListener;
import org.apache.aries.cdi.container.internal.container.ContainerBootstrap;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.ExtensionPhase;
import org.apache.aries.cdi.container.internal.model.ContainerActivator;
import org.apache.aries.cdi.container.internal.model.ContainerComponent;
import org.apache.aries.cdi.container.internal.model.FactoryActivator;
import org.apache.aries.cdi.container.internal.model.FactoryComponent;
import org.apache.aries.cdi.container.internal.model.SingleActivator;
import org.apache.aries.cdi.container.internal.model.SingleComponent;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cdi.runtime.CDIComponentRuntime;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.annotations.RequireConfigurationAdmin;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.tracker.ServiceTracker;

@Header(name="Bundle-Activator", value="${@class}")
@RequireConfigurationAdmin
public class Activator
extends AbstractExtender {
    private static final Logs _logs = new Logs.Builder(FrameworkUtil.getBundle(Activator.class).getBundleContext()).build();
    private static final Logger _log = _logs.getLogger(Activator.class);
    private static final ThreadGroup _threadGroup = new ThreadGroup("Apache Aries CCR - CDI");
    private static final ExecutorService _executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(_threadGroup, r, "Aries CCR Thread");
            t.setDaemon(true);
            return t;
        }
    });
    private static final PromiseFactory _promiseFactory = new PromiseFactory((Executor)_executorService);
    public static final CCR ccr = new CCR(_promiseFactory, _logs);
    private BundleContext _bundleContext;
    private final ChangeCount _ccrChangeCount = new ChangeCount();
    private ServiceRegistration<CDIComponentRuntime> _ccrRegistration;
    private volatile CDICommand _command;
    private ServiceRegistration<?> _commandRegistration;

    public Activator() {
        this.setSynchronous(true);
    }

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("CCR starting {}", (Object)bundleContext.getBundle());
        }
        this._command = new CDICommand(ccr);
        this._bundleContext = bundleContext;
        this.registerCCR();
        this.registerCDICommand();
        super.start(bundleContext);
        if (_log.isDebugEnabled()) {
            _log.debug("CCR started {}", (Object)bundleContext.getBundle());
        }
    }

    private void registerCCR() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.changecount", this._ccrChangeCount.get());
        ((Dictionary)properties).put("service.description", "Aries CDI - CDI Component Runtime");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ChangeObserverFactory changeObserverFactory = new ChangeObserverFactory();
        this._ccrChangeCount.addObserver(changeObserverFactory);
        this._ccrRegistration = this._bundleContext.registerService(CDIComponentRuntime.class, (ServiceFactory)changeObserverFactory, properties);
    }

    private void registerCDICommand() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "cdi");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"list", "info"});
        ((Dictionary)properties).put("service.description", "Aries CDI - Gogo Commands");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        this._commandRegistration = this._bundleContext.registerService(Object.class, (Object)this._command, properties);
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("CCR stoping {}", (Object)bundleContext.getBundle());
        }
        super.stop(bundleContext);
        this._commandRegistration.unregister();
        this._ccrRegistration.unregister();
        if (_log.isDebugEnabled()) {
            _log.debug("CCR stoped {}", (Object)bundleContext.getBundle());
        }
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        if (!this.requiresCDIExtender(bundle)) {
            return null;
        }
        ServiceTracker caTracker = new ServiceTracker(bundle.getBundleContext(), ConfigurationAdmin.class, null);
        caTracker.open();
        ServiceTracker loggerTracker = new ServiceTracker(bundle.getBundleContext(), LoggerFactory.class, null);
        loggerTracker.open();
        ContainerState containerState = new ContainerState(bundle, this._bundleContext.getBundle(), this._ccrChangeCount, _promiseFactory, (ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>)caTracker, _logs);
        return new CDIBundle(ccr, containerState, new ExtensionPhase(containerState, new ConfigurationListener.Builder(containerState).component(new ContainerComponent.Builder(containerState, new ContainerActivator.Builder(containerState, new ContainerBootstrap(containerState, new ConfigurationListener.Builder(containerState), new SingleComponent.Builder(containerState, new SingleActivator.Builder(containerState)), new FactoryComponent.Builder(containerState, new FactoryActivator.Builder(containerState))))).build()).build()));
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        if (_log.isTraceEnabled()) {
            _log.trace(msg, (Object)bundle);
        }
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        if (_log.isWarnEnabled()) {
            _log.warn(msg, (Object)bundle, (Object)t);
        }
    }

    @Override
    protected void error(String msg, Throwable t) {
        if (_log.isErrorEnabled()) {
            _log.error(msg, (Object)t);
        }
    }

    private boolean requiresCDIExtender(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List requiredBundleWires = bundleWiring.getRequiredWires("osgi.extender");
        for (BundleWire bundleWire : requiredBundleWires) {
            BundleRequirement requirement;
            Map requirementAttributes;
            List beans;
            Bundle providerWiringBundle;
            Map attributes = bundleWire.getCapability().getAttributes();
            if (!attributes.containsKey("osgi.extender") || !attributes.get("osgi.extender").equals("osgi.cdi") || !(providerWiringBundle = bundleWire.getProviderWiring().getBundle()).equals(this._bundleContext.getBundle()) || (beans = (List)(requirementAttributes = (requirement = bundleWire.getRequirement()).getAttributes()).get("beans")) == null || beans.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private class ChangeObserverFactory
    implements Observer,
    ServiceFactory<CDIComponentRuntime> {
        private final List<ServiceRegistration<CDIComponentRuntime>> _registrations = new CopyOnWriteArrayList<ServiceRegistration<CDIComponentRuntime>>();

        private ChangeObserverFactory() {
        }

        public CDIComponentRuntime getService(Bundle bundle, ServiceRegistration<CDIComponentRuntime> registration) {
            this._registrations.add(registration);
            return ccr;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<CDIComponentRuntime> registration, CDIComponentRuntime service) {
            this._registrations.remove(registration);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangeCount)) {
                return;
            }
            ChangeCount changeCount = (ChangeCount)o;
            for (ServiceRegistration<CDIComponentRuntime> registration : this._registrations) {
                Dictionary properties = registration.getReference().getProperties();
                properties.put("service.changecount", changeCount.get());
                registration.setProperties(properties);
            }
        }
    }
}

