/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;

public class BundleClassLoader
extends URLClassLoader {
    private final Bundle[] _bundles;
    private final ConcurrentMap<String, Class<?>> _cache = new ConcurrentHashMap();

    public BundleClassLoader(Bundle[] bundles) {
        super(new URL[0]);
        if (bundles.length == 0) {
            throw new IllegalArgumentException("At least one bundle is required");
        }
        this._bundles = bundles;
    }

    @Override
    public URL findResource(String name) {
        for (Bundle bundle : this._bundles) {
            URL url = bundle.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        for (Bundle bundle : this._bundles) {
            try {
                Enumeration enumeration = bundle.getResources(name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                return enumeration;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Collections.emptyEnumeration();
    }

    public Bundle[] getBundles() {
        return this._bundles;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Object classLoadingLock;
        Object object = classLoadingLock = this.getClassLoadingLock(name);
        synchronized (object) {
            for (Bundle bundle : this._bundles) {
                try {
                    return bundle.loadClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object classLoadingLock;
        Object object = classLoadingLock = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = (Class<?>)this._cache.get(name);
            if (clazz == null) {
                clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                this._cache.put(name, clazz);
            }
            return clazz;
        }
    }
}

