/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.blueprint.container;

import org.apache.aries.blueprint.di.Recipe;

/**
 * Interface used to describe an object which can satisfy a constraint or not.
 *
 * If the state of the object changes, registered SatisfactionListener objects
 * will be notified of the change.
 *
 * @version $Rev: 1821610 $, $Date: 2018-01-19 10:44:57 +0100 (Fri, 19 Jan 2018) $
 */
public interface SatisfiableRecipe extends Recipe {

    /**
     * A listener that will be notified when the constraint satisfaction changes.
     *
     * @version $Rev: 1821610 $, $Date: 2018-01-19 10:44:57 +0100 (Fri, 19 Jan 2018) $
     */
    public interface SatisfactionListener {

        void notifySatisfaction(SatisfiableRecipe satisfiable);

    }

    void start(SatisfactionListener listener);
    
    void stop();
    
    boolean isSatisfied();

    String getOsgiFilter();

    boolean isStaticLifecycle();

}
