/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.annotation.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.aries.blueprint.annotation.Arg;
import org.apache.aries.blueprint.annotation.Bean;
import org.apache.aries.blueprint.annotation.Bind;
import org.apache.aries.blueprint.annotation.Blueprint;
import org.apache.aries.blueprint.annotation.Destroy;
import org.apache.aries.blueprint.annotation.Init;
import org.apache.aries.blueprint.annotation.Inject;
import org.apache.aries.blueprint.annotation.Reference;
import org.apache.aries.blueprint.annotation.ReferenceList;
import org.apache.aries.blueprint.annotation.ReferenceListener;
import org.apache.aries.blueprint.annotation.Register;
import org.apache.aries.blueprint.annotation.RegistrationListener;
import org.apache.aries.blueprint.annotation.Service;
import org.apache.aries.blueprint.annotation.ServiceProperty;
import org.apache.aries.blueprint.annotation.Unbind;
import org.apache.aries.blueprint.annotation.Unregister;
import org.apache.aries.blueprint.annotation.impl.BlueprintAnnotationException;
import org.apache.aries.blueprint.annotation.service.BlueprintAnnotationScanner;
import org.apache.aries.blueprint.jaxb.Targument;
import org.apache.aries.blueprint.jaxb.Tbean;
import org.apache.aries.blueprint.jaxb.Tblueprint;
import org.apache.aries.blueprint.jaxb.Tdescription;
import org.apache.aries.blueprint.jaxb.Tinterfaces;
import org.apache.aries.blueprint.jaxb.Tproperty;
import org.apache.aries.blueprint.jaxb.Treference;
import org.apache.aries.blueprint.jaxb.TreferenceList;
import org.apache.aries.blueprint.jaxb.TreferenceListener;
import org.apache.aries.blueprint.jaxb.TregistrationListener;
import org.apache.aries.blueprint.jaxb.Tservice;
import org.apache.aries.blueprint.jaxb.TservicePropertyEntry;
import org.apache.aries.blueprint.jaxb.TserviceReference;
import org.apache.aries.blueprint.jaxb.TtypeConverters;
import org.apache.aries.blueprint.jaxb.Tvalue;
import org.apache.xbean.finder.BundleAnnotationFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.Converter;
import org.osgi.service.packageadmin.PackageAdmin;

public class BlueprintAnnotationScannerImpl
implements BlueprintAnnotationScanner {
    private final BundleContext context;

    public BlueprintAnnotationScannerImpl(BundleContext bc) {
        this.context = bc;
    }

    private BundleContext getBlueprintExtenderContext() {
        Bundle[] bundles;
        for (Bundle b : bundles = this.context.getBundles()) {
            if (!b.getSymbolicName().equals("org.apache.aries.blueprint.core")) continue;
            return b.getBundleContext();
        }
        return null;
    }

    private BundleAnnotationFinder createBundleAnnotationFinder(Bundle bundle) {
        ServiceReference sr = this.context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)this.context.getService(sr);
        BundleAnnotationFinder baf = null;
        try {
            baf = new BundleAnnotationFinder(pa, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.context.ungetService(sr);
        return baf;
    }

    public URL createBlueprintModel(Bundle bundle) {
        Tblueprint tblueprint = this.generateBlueprintModel(bundle);
        if (tblueprint != null) {
            String blueprintPath;
            File file;
            File dir;
            BundleContext ctx = this.getBlueprintExtenderContext();
            if (ctx == null) {
                ctx = bundle.getBundleContext();
            }
            if (!(dir = ctx.getDataFile(bundle.getSymbolicName() + "/" + bundle.getVersion() + "/")).exists()) {
                dir.mkdirs();
            }
            if (!(file = ctx.getDataFile(blueprintPath = this.cachePath(bundle, "annotation-generated-blueprint.xml"))).exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.marshallOBRModel(tblueprint, file);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void marshallOBRModel(Tblueprint tblueprint, File blueprintFile) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Tblueprint.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)tblueprint, blueprintFile);
    }

    private Tblueprint generateBlueprintModel(Bundle bundle) {
        Object tref;
        Bean bean;
        BundleAnnotationFinder baf = this.createBundleAnnotationFinder(bundle);
        LinkedHashSet blueprintClasses = new LinkedHashSet(baf.findAnnotatedClasses(Blueprint.class));
        HashSet beanClasses = new HashSet(baf.findAnnotatedClasses(Bean.class));
        HashSet refListenerClasses = new HashSet(baf.findAnnotatedClasses(ReferenceListener.class));
        HashSet regListenerClasses = new HashSet(baf.findAnnotatedClasses(RegistrationListener.class));
        HashMap<String, TreferenceListener> reflMap = new HashMap<String, TreferenceListener>();
        HashMap<String, TregistrationListener> reglMap = new HashMap<String, TregistrationListener>();
        Tblueprint tblueprint = new Tblueprint();
        if (!blueprintClasses.isEmpty()) {
            Blueprint blueprint = ((Class)blueprintClasses.iterator().next()).getAnnotation(Blueprint.class);
            tblueprint.setDefaultActivation(blueprint.defaultActivation());
            tblueprint.setDefaultAvailability(blueprint.defaultAvailability());
            tblueprint.setDefaultTimeout(this.convertToBigInteger(blueprint.defaultTimeout()));
        }
        List<Object> components = tblueprint.getServiceOrReferenceListOrBean();
        for (Class refListener : refListenerClasses) {
            bean = refListener.getAnnotation(Bean.class);
            tref = this.generateTrefListener(refListener);
            if (bean.id().length() > 0) {
                reflMap.put(bean.id(), (TreferenceListener)tref);
                continue;
            }
            throw new BlueprintAnnotationException("Unable to find the id for the @ReferenceListener annotated class " + refListener.getName());
        }
        for (Class regListener : regListenerClasses) {
            bean = regListener.getAnnotation(Bean.class);
            tref = this.generateTregListener(regListener);
            if (bean.id().length() > 0) {
                reglMap.put(bean.id(), (TregistrationListener)tref);
                continue;
            }
            throw new BlueprintAnnotationException("Unable to find the id for the @RegistrationListener annotated class " + regListener.getName());
        }
        for (Class clazz : beanClasses) {
            boolean isConverter;
            String factoryMethod;
            String factoryRef;
            String scope;
            bean = clazz.getAnnotation(Bean.class);
            Tbean tbean = new Tbean();
            String[] dependsOn = bean.dependsOn();
            if (!this.containsValid(dependsOn)) {
                tbean.setDependsOn(null);
            } else {
                List<String> dons = Arrays.asList(dependsOn);
                tbean.setDependsOn(dons);
            }
            String id = bean.id();
            if (id.length() > 0) {
                tbean.setId(id);
            } else {
                tbean.setId(clazz.getSimpleName());
            }
            tbean.setClazz(clazz.getName());
            String activation = bean.activation();
            if (activation.length() > 0) {
                if (activation.equalsIgnoreCase("eager") || activation.equalsIgnoreCase("lazy")) {
                    tbean.setActivation(bean.activation());
                } else {
                    throw new BlueprintAnnotationException("Invalid bean activation value " + activation + " for " + clazz.getName());
                }
            }
            if (bean.description().length() > 0) {
                Tdescription desp = new Tdescription();
                desp.getContent().add(bean.description());
                tbean.setDescription(desp);
            }
            if ((scope = bean.scope()).length() > 0) {
                if (scope.equalsIgnoreCase("singleton") || scope.equalsIgnoreCase("prototype")) {
                    tbean.setScope(scope);
                } else {
                    throw new BlueprintAnnotationException("Invalid bean scope value " + scope + " for " + clazz.getName());
                }
            }
            if ((factoryRef = bean.factoryRef()).length() > 0) {
                tbean.setFactoryRef(factoryRef);
            }
            if ((factoryMethod = bean.factoryMethod()).length() > 0) {
                tbean.setFactoryMethod(factoryMethod);
            }
            List<Object> props = tbean.getArgumentOrPropertyOrAny();
            Arg[] args = bean.args();
            if (args.length > 0) {
                for (int i = 0; i < args.length; ++i) {
                    Targument targ = this.createTargument(args[i]);
                    if (targ == null) continue;
                    props.add(targ);
                }
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                TserviceReference tref2;
                Reference ref;
                if (!fields[i].isAnnotationPresent(Inject.class)) continue;
                if (fields[i].isAnnotationPresent(Reference.class)) {
                    ref = fields[i].getAnnotation(Reference.class);
                    tref2 = this.generateTref(ref, reflMap);
                    components.add(tref2);
                    continue;
                }
                if (fields[i].isAnnotationPresent(ReferenceList.class)) {
                    ref = fields[i].getAnnotation(ReferenceList.class);
                    tref2 = this.generateTrefList((ReferenceList)ref, reflMap);
                    components.add(tref2);
                    continue;
                }
                Tproperty tp = this.createTproperty(fields[i].getName(), fields[i].getAnnotation(Inject.class));
                props.add(tp);
            }
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].isAnnotationPresent(Init.class)) {
                    tbean.setInitMethod(methods[i].getName());
                    continue;
                }
                if (methods[i].isAnnotationPresent(Destroy.class)) {
                    tbean.setDestroyMethod(methods[i].getName());
                    continue;
                }
                if (methods[i].isAnnotationPresent(Inject.class)) {
                    String propertyName = this.convertFromMethodName(methods[i].getName());
                    Tproperty tp = this.createTproperty(propertyName, methods[i].getAnnotation(Inject.class));
                    props.add(tp);
                    continue;
                }
                if (!methods[i].isAnnotationPresent(Arg.class)) continue;
                Targument targ = this.createTargument(methods[i].getAnnotation(Arg.class));
                props.add(targ);
            }
            if (clazz.getAnnotation(Service.class) != null) {
                Tservice tservice = this.generateTservice(clazz, id, reglMap);
                components.add(tservice);
            }
            if (isConverter = this.isConverter(clazz)) {
                TtypeConverters converters = tblueprint.getTypeConverters();
                List<Object> objects = converters.getBeanOrReferenceOrRef();
                objects.add(tbean);
                continue;
            }
            components.add(tbean);
        }
        return tblueprint;
    }

    private TreferenceListener generateTrefListener(Class refListener) {
        ReferenceListener rl = refListener.getAnnotation(ReferenceListener.class);
        String ref = rl.ref();
        String bind = null;
        String unbind = null;
        Method[] methods = refListener.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].isAnnotationPresent(Bind.class)) {
                if (bind == null) {
                    bind = methods[i].getName();
                    continue;
                }
                if (bind.equals(methods[i].getName())) continue;
                throw new BlueprintAnnotationException("@Bind annottaed method for reference listener " + refListener.getName() + " are not consistent");
            }
            if (!methods[i].isAnnotationPresent(Unbind.class)) continue;
            if (unbind == null) {
                unbind = methods[i].getName();
                continue;
            }
            if (unbind.equals(methods[i].getName())) continue;
            throw new BlueprintAnnotationException("@Unbind annotated method for reference listener " + refListener.getName() + " are not consistent");
        }
        TreferenceListener trl = new TreferenceListener();
        if (bind != null) {
            trl.setBindMethod(bind);
        }
        if (unbind != null) {
            trl.setUnbindMethod(unbind);
        }
        if (ref != null) {
            trl.setRefAttribute(ref);
        }
        return trl;
    }

    private TregistrationListener generateTregListener(Class regListener) {
        RegistrationListener rl = regListener.getAnnotation(RegistrationListener.class);
        String register = null;
        String unregister = null;
        Method[] methods = regListener.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].isAnnotationPresent(Register.class)) {
                if (register == null) {
                    register = methods[i].getName();
                    continue;
                }
                if (register.equals(methods[i].getName())) continue;
                throw new BlueprintAnnotationException("@Register annottaed method for registration listener " + regListener.getName() + " are not consistent");
            }
            if (!methods[i].isAnnotationPresent(Unregister.class)) continue;
            if (unregister == null) {
                unregister = methods[i].getName();
                continue;
            }
            if (unregister.equals(methods[i].getName())) continue;
            throw new BlueprintAnnotationException("@Unregister annotated method for registration listener " + regListener.getName() + " are not consistent");
        }
        TregistrationListener trl = new TregistrationListener();
        if (register != null) {
            trl.setRegistrationMethod(register);
        }
        if (unregister != null) {
            trl.setUnregistrationMethod(unregister);
        }
        return trl;
    }

    private Targument createTargument(Arg arg) {
        String value = arg.value();
        String ref = arg.ref();
        Targument targ = null;
        if (value.length() > 0) {
            targ = new Targument();
            targ.setValueAttribute(value);
        }
        if (ref.length() > 0) {
            if (targ == null) {
                targ = new Targument();
            }
            targ.setRefAttribute(ref);
        }
        return targ;
    }

    private String convertFromMethodName(String name) {
        if (name.length() <= 3) {
            throw new BlueprintAnnotationException("The annotated method name " + name + " is invalid");
        }
        name = name.substring(3);
        String firstChar = name.substring(0, 1).toLowerCase();
        if (name.length() == 1) {
            return firstChar;
        }
        return firstChar + name.substring(1);
    }

    private Tproperty createTproperty(String nm, Inject inj) {
        String value = inj.value();
        String ref = inj.ref();
        String name = inj.name();
        String desp = inj.description();
        Tproperty tp = new Tproperty();
        if (value.length() > 0) {
            Tvalue tvalue = new Tvalue();
            tvalue.setContent(value);
            tp.setValue(tvalue);
        }
        if (ref.length() > 0) {
            tp.setRefAttribute(ref);
        }
        if (name.length() > 0) {
            tp.setName(name);
        } else {
            tp.setName(nm);
        }
        if (desp.length() > 0) {
            Tdescription tdesp = new Tdescription();
            tdesp.getContent().add(desp);
            tp.setDescription(tdesp);
        }
        return tp;
    }

    private boolean isConverter(Class clazz) {
        Class<?>[] classes = clazz.getInterfaces();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(Converter.class.getName())) continue;
            return true;
        }
        return false;
    }

    private BigInteger convertToBigInteger(int timeout) {
        return BigInteger.valueOf(timeout * 1000);
    }

    private boolean containsValid(String[] dependsOn) {
        for (int i = 0; i < dependsOn.length; ++i) {
            if (dependsOn[i].length() == 0) continue;
            return true;
        }
        return false;
    }

    private String cachePath(Bundle bundle, String filePath) {
        return bundle.getSymbolicName() + "/" + bundle.getVersion() + "/" + filePath;
    }

    private Treference generateTref(Reference ref, Map<String, TreferenceListener> reflMap) {
        String id = ref.id();
        String availability = ref.availability();
        String compName = ref.componentName();
        String desp = ref.description();
        String filter = ref.filter();
        Class serviceInterface = ref.serviceInterface();
        ReferenceListener[] refListeners = ref.referenceListeners();
        int timeout = ref.timeout();
        Treference tref = new Treference();
        tref.setDependsOn(null);
        if (id.length() > 0) {
            tref.setId(id);
        }
        if (availability.length() > 0) {
            tref.setAvailability(availability);
        }
        if (compName.length() > 0) {
            tref.setComponentName(compName);
        }
        if (desp.length() > 0) {
            Tdescription value = new Tdescription();
            value.getContent().add(desp);
            tref.setDescription(value);
        }
        if (filter.length() > 0) {
            tref.setFilter(filter);
        }
        if (serviceInterface != Object.class) {
            tref.setInterface(serviceInterface.getName());
        }
        if (timeout > 0) {
            tref.setTimeout(this.convertToBigInteger(timeout));
        }
        for (ReferenceListener rl : refListeners) {
            String rf = rl.ref();
            TreferenceListener trl = reflMap.get(rf);
            if (trl == null) {
                throw new BlueprintAnnotationException("Unable to find the ReferenceListener ref " + rf);
            }
            trl.setRefAttribute(rf);
            tref.getReferenceListener().add(trl);
        }
        return tref;
    }

    private TreferenceList generateTrefList(ReferenceList ref, Map<String, TreferenceListener> reflMap) {
        String id = ref.id();
        String availability = ref.availability();
        String compName = ref.componentName();
        String desp = ref.description();
        String filter = ref.filter();
        Class serviceInterface = ref.serviceInterface();
        ReferenceListener[] refListeners = ref.referenceListeners();
        TreferenceList tref = new TreferenceList();
        tref.setDependsOn(null);
        if (id.length() > 0) {
            tref.setId(id);
        }
        if (availability.length() > 0) {
            tref.setAvailability(availability);
        }
        if (compName.length() > 0) {
            tref.setComponentName(compName);
        }
        if (desp.length() > 0) {
            Tdescription value = new Tdescription();
            value.getContent().add(desp);
            tref.setDescription(value);
        }
        if (filter.length() > 0) {
            tref.setFilter(filter);
        }
        if (serviceInterface != Object.class) {
            tref.setInterface(serviceInterface.getName());
        }
        for (ReferenceListener rl : refListeners) {
            String rf = rl.ref();
            TreferenceListener trl = reflMap.get(rf);
            if (trl == null) {
                throw new BlueprintAnnotationException("Unable to find the ReferenceListener ref " + rf);
            }
            trl.setRefAttribute(rf);
            tref.getReferenceListener().add(trl);
        }
        return tref;
    }

    private Tservice generateTservice(Class clazz, String id, Map<String, TregistrationListener> reglMap) {
        Service service = clazz.getAnnotation(Service.class);
        Class[] interfaces = service.interfaces();
        int ranking = service.ranking();
        String autoExport = service.autoExport();
        ServiceProperty[] serviceProperties = service.serviceProperties();
        RegistrationListener[] regListeners = service.registerationListeners();
        Tservice tservice = new Tservice();
        tservice.setDependsOn(null);
        tservice.setRefAttribute(id);
        if (autoExport.length() > 0) {
            tservice.setAutoExport(autoExport);
        }
        if (ranking > 0) {
            tservice.setRanking(ranking);
        }
        for (Class clazz2 : interfaces) {
            Tinterfaces tInterfaces = new Tinterfaces();
            if (clazz2 != null) {
                tInterfaces.getValue().add(clazz2.getName());
            }
            tservice.setInterfaces(tInterfaces);
        }
        for (Class clazz3 : serviceProperties) {
            if (clazz3 == null) continue;
            String key = clazz3.key();
            String value = clazz3.value();
            if (key.length() <= 0 || value.length() <= 0) continue;
            TservicePropertyEntry tsp = new TservicePropertyEntry();
            tsp.setKey(key);
            tsp.setValueAttribute(value);
            tservice.getServiceProperties().getEntry().add(tsp);
        }
        for (Class clazz4 : regListeners) {
            String ref = clazz4.ref();
            if (ref.length() <= 0) {
                throw new BlueprintAnnotationException("No ref id for service registration listener  for " + clazz.getName());
            }
            TregistrationListener tregListener = reglMap.get(ref);
            tregListener.setRefAttribute(ref);
            tservice.getRegistrationListener().add(tregListener);
        }
        return tservice;
    }
}

