/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.common.ldap.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Rdn;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapper;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapperConfiguration;
import org.apache.archiva.redback.common.ldap.user.LdapUser;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapRoleMapper#default")
public class DefaultLdapRoleMapper
implements LdapRoleMapper {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="ldapConnectionFactory#configurable")
    private LdapConnectionFactory ldapConnectionFactory;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;
    @Inject
    @Named(value="ldapRoleMapperConfiguration#default")
    private LdapRoleMapperConfiguration ldapRoleMapperConfiguration;
    @Inject
    @Named(value="userManager#default")
    private UserManager userManager;
    private String ldapGroupClass = "groupOfUniqueNames";
    private String groupsDn;
    private String groupFilter;
    private String baseDn;
    private String ldapGroupMember = "uniqueMember";
    private boolean useDefaultRoleName = false;
    private String dnAttr = "dn";
    private String userIdAttribute = "uid";

    @PostConstruct
    public void initialize() {
        this.ldapGroupClass = this.userConf.getString("ldap.config.groups.class", this.ldapGroupClass);
        this.baseDn = this.userConf.getConcatenatedList("ldap.config.base.dn", this.baseDn);
        this.groupsDn = this.userConf.getConcatenatedList("ldap.config.groups.base.dn", this.groupsDn);
        if (StringUtils.isEmpty((String)this.groupsDn)) {
            this.groupsDn = this.baseDn;
        }
        this.groupFilter = this.userConf.getString("ldap.config.groups.filter", this.groupFilter);
        this.useDefaultRoleName = this.userConf.getBoolean("ldap.config.groups.use.rolename", this.useDefaultRoleName);
        this.userIdAttribute = this.userConf.getString("ldap.config.user.attribute", this.userIdAttribute);
        this.ldapGroupMember = this.userConf.getString("ldap.config.groups.member", this.ldapGroupMember);
        this.dnAttr = this.userConf.getString("ldap.config.dn", this.dnAttr);
    }

    @Override
    public List<String> getAllGroups(DirContext context) throws MappingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            if (!StringUtils.isEmpty((String)this.groupFilter)) {
                filter = "(&(" + filter + ")(" + this.groupFilter + "))";
            }
            namingEnumeration = context.search(this.getGroupsDn(), filter, searchControls);
            ArrayList<String> allGroups = new ArrayList<String>();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String groupName = searchResult.getName();
                groupName = StringUtils.substringAfter((String)groupName, (String)"=");
                this.log.debug("found groupName: '{}", (Object)groupName);
                allGroups.add(groupName);
            }
            ArrayList<String> arrayList = allGroups;
            return arrayList;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.close(namingEnumeration);
        }
    }

    protected void closeNamingEnumeration(NamingEnumeration namingEnumeration) {
        if (namingEnumeration != null) {
            try {
                namingEnumeration.close();
            }
            catch (NamingException e) {
                this.log.warn("failed to close NamingEnumeration", (Throwable)e);
            }
        }
    }

    @Override
    public boolean hasRole(DirContext context, String roleName) throws MappingException {
        String groupName = this.findGroupName(roleName);
        if (groupName == null) {
            if (this.useDefaultRoleName) {
                groupName = roleName;
            } else {
                this.log.warn("skip group creation as no mapping for roleName:'{}'", (Object)roleName);
                return false;
            }
        }
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            namingEnumeration = context.search("cn=" + groupName + "," + this.getGroupsDn(), filter, searchControls);
            boolean bl = namingEnumeration.hasMore();
            return bl;
        }
        catch (NameNotFoundException e) {
            this.log.debug("group {} for role {} not found", (Object)groupName, (Object)roleName);
            boolean bl = false;
            return bl;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.close(namingEnumeration);
        }
    }

    @Override
    public List<String> getAllRoles(DirContext context) throws MappingException {
        List<String> groups = this.getAllGroups(context);
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> roles = new HashSet<String>(groups.size());
        Map<String, Collection<String>> mapping = this.ldapRoleMapperConfiguration.getLdapGroupMappings();
        for (String group : groups) {
            Collection<String> rolesPerGroup = mapping.get(group);
            if (rolesPerGroup == null) continue;
            for (String role : rolesPerGroup) {
                roles.add(role);
            }
        }
        return new ArrayList<String>(roles);
    }

    @Override
    public List<String> getGroupsMember(String group, DirContext context) throws MappingException {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            namingEnumeration = context.search("cn=" + group + "," + this.getGroupsDn(), filter, searchControls);
            ArrayList<String> allMembers = new ArrayList<String>();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute uniqueMemberAttr = searchResult.getAttributes().get(this.getLdapGroupMember());
                if (uniqueMemberAttr == null) continue;
                NamingEnumeration<?> allMembersEnum = uniqueMemberAttr.getAll();
                while (allMembersEnum.hasMore()) {
                    String userName = (String)allMembersEnum.next();
                    userName = StringUtils.substringAfter((String)userName, (String)"=");
                    userName = StringUtils.substringBefore((String)userName, (String)",");
                    this.log.debug("found userName for group {}: '{}", (Object)group, (Object)userName);
                    allMembers.add(userName);
                }
                this.close(allMembersEnum);
            }
            ArrayList<String> arrayList = allMembers;
            return arrayList;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.close(namingEnumeration);
        }
    }

    @Override
    public List<String> getGroups(String username, DirContext context) throws MappingException {
        ArrayList<String> userGroups = new ArrayList<String>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String groupEntry = null;
            try {
                LdapUser ldapUser;
                Attribute dnAttribute;
                User user = this.userManager.findUser(username);
                if (user instanceof LdapUser && (dnAttribute = (ldapUser = (LdapUser)LdapUser.class.cast(user)).getOriginalAttributes().get(this.getLdapDnAttribute())) != null) {
                    groupEntry = (String)String.class.cast(dnAttribute.get());
                }
            }
            catch (UserNotFoundException e) {
                this.log.warn("Failed to look up user {}. Computing distinguished name manually", (Object)username, (Object)e);
            }
            catch (UserManagerException e) {
                this.log.warn("Failed to look up user {}. Computing distinguished name manually", (Object)username, (Object)e);
            }
            if (groupEntry == null) {
                StringBuilder builder = new StringBuilder();
                String posixGroup = "posixGroup";
                if (posixGroup.equals(this.getLdapGroupClass())) {
                    builder.append(username);
                } else {
                    builder.append(this.userIdAttribute).append("=").append(username).append(",").append(this.getBaseDn());
                }
                groupEntry = builder.toString();
            }
            String filter = "(&" + ("(objectClass=" + this.getLdapGroupClass() + ")") + "(" + this.getLdapGroupMember() + "=" + Rdn.escapeValue(groupEntry) + ")" + ")";
            this.log.debug("filter: {}", (Object)filter);
            namingEnumeration = context.search(this.getGroupsDn(), filter, searchControls);
            while (namingEnumeration.hasMore()) {
                String groupName;
                SearchResult searchResult = namingEnumeration.next();
                ArrayList<String> allMembers = new ArrayList<String>();
                Attribute uniqueMemberAttr = searchResult.getAttributes().get(this.getLdapGroupMember());
                if (uniqueMemberAttr != null) {
                    NamingEnumeration<?> allMembersEnum = uniqueMemberAttr.getAll();
                    while (allMembersEnum.hasMore()) {
                        String userName = (String)allMembersEnum.next();
                        allMembers.add(userName);
                        userName = StringUtils.substringAfter((String)userName, (String)"=");
                        userName = StringUtils.substringBefore((String)userName, (String)",");
                        allMembers.add(userName);
                    }
                    this.close(allMembersEnum);
                }
                if (allMembers.contains(username)) {
                    groupName = searchResult.getName();
                    groupName = StringUtils.substringAfter((String)groupName, (String)"=");
                    userGroups.add(groupName);
                    continue;
                }
                if (!allMembers.contains(groupEntry)) continue;
                groupName = searchResult.getName();
                groupName = StringUtils.substringAfter((String)groupName, (String)"=");
                userGroups.add(groupName);
            }
            ArrayList<String> arrayList = userGroups;
            return arrayList;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.close(namingEnumeration);
        }
    }

    @Override
    public List<String> getRoles(String username, DirContext context, Collection<String> realRoles) throws MappingException {
        List<String> groups = this.getGroups(username, context);
        Map<String, Collection<String>> rolesMapping = this.ldapRoleMapperConfiguration.getLdapGroupMappings();
        HashSet<String> roles = new HashSet<String>(groups.size());
        for (String group : groups) {
            Collection<String> rolesPerGroup = rolesMapping.get(group);
            if (rolesPerGroup != null) {
                roles.addAll(rolesPerGroup);
                continue;
            }
            if (!this.useDefaultRoleName || realRoles == null || !realRoles.contains(group)) continue;
            roles.add(group);
        }
        return new ArrayList<String>(roles);
    }

    private void close(NamingEnumeration namingEnumeration) {
        if (namingEnumeration != null) {
            try {
                namingEnumeration.close();
            }
            catch (NamingException e) {
                this.log.warn("fail to close namingEnumeration: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public String getGroupsDn() {
        return this.groupsDn;
    }

    @Override
    public String getLdapGroupClass() {
        return this.ldapGroupClass;
    }

    public String getLdapDnAttribute() {
        return this.dnAttr;
    }

    @Override
    public boolean saveRole(String roleName, DirContext context) throws MappingException {
        List<String> allGroups;
        if (this.hasRole(context, roleName)) {
            return true;
        }
        String groupName = this.findGroupName(roleName);
        if (groupName == null) {
            if (this.useDefaultRoleName) {
                groupName = roleName;
            } else {
                this.log.warn("skip group creation as no mapping for roleName:'{}'", (Object)roleName);
                return false;
            }
        }
        if ((allGroups = this.getAllGroups(context)).contains(groupName)) {
            this.log.info("group {} already exists for role.", (Object)groupName, (Object)roleName);
            return false;
        }
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("groupOfUniqueNames");
        attributes.put(objectClass);
        attributes.put("cn", groupName);
        BasicAttribute basicAttribute = new BasicAttribute(this.getLdapGroupMember());
        basicAttribute.add(this.userIdAttribute + "=admin," + this.getBaseDn());
        attributes.put(basicAttribute);
        try {
            String dn = "cn=" + groupName + "," + this.groupsDn;
            context.createSubcontext(dn, (Attributes)attributes);
            this.log.info("created group with dn:'{}", (Object)dn);
            return true;
        }
        catch (NameAlreadyBoundException e) {
            this.log.info("skip group '{}' creation as already exists", (Object)groupName);
            return true;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    @Override
    public boolean saveUserRole(String roleName, String username, DirContext context) throws MappingException {
        String groupName = this.findGroupName(roleName);
        if (groupName == null) {
            this.log.warn("no group found for role '{}", (Object)roleName);
            groupName = roleName;
        }
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            namingEnumeration = context.search("cn=" + groupName + "," + this.getGroupsDn(), filter, searchControls);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute attribute = searchResult.getAttributes().get(this.getLdapGroupMember());
                if (attribute == null) {
                    BasicAttribute basicAttribute = new BasicAttribute(this.getLdapGroupMember());
                    basicAttribute.add(this.userIdAttribute + "=" + username + "," + this.getBaseDn());
                    context.modifyAttributes("cn=" + groupName + "," + this.getGroupsDn(), new ModificationItem[]{new ModificationItem(1, basicAttribute)});
                } else {
                    attribute.add(this.userIdAttribute + "=" + username + "," + this.getBaseDn());
                    context.modifyAttributes("cn=" + groupName + "," + this.getGroupsDn(), new ModificationItem[]{new ModificationItem(2, attribute)});
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            if (namingEnumeration != null) {
                try {
                    namingEnumeration.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean removeUserRole(String roleName, String username, DirContext context) throws MappingException {
        String groupName = this.findGroupName(roleName);
        if (groupName == null) {
            this.log.warn("no group found for role '{}", (Object)roleName);
            return false;
        }
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            namingEnumeration = context.search("cn=" + groupName + "," + this.getGroupsDn(), filter, searchControls);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute attribute = searchResult.getAttributes().get(this.getLdapGroupMember());
                if (attribute != null) {
                    BasicAttribute basicAttribute = new BasicAttribute(this.getLdapGroupMember());
                    basicAttribute.add(this.userIdAttribute + "=" + username + "," + this.getGroupsDn());
                    context.modifyAttributes("cn=" + groupName + "," + this.getGroupsDn(), new ModificationItem[]{new ModificationItem(3, basicAttribute)});
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            if (namingEnumeration != null) {
                try {
                    namingEnumeration.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void removeAllRoles(DirContext context) throws MappingException {
        Set<String> groups = this.ldapRoleMapperConfiguration.getLdapGroupMappings().keySet();
        try {
            for (String groupName : groups) {
                String dn = "cn=" + groupName + "," + this.groupsDn;
                context.unbind(dn);
                this.log.debug("deleted group with dn:'{}", (Object)dn);
            }
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    @Override
    public void removeRole(String roleName, DirContext context) throws MappingException {
        String groupName = this.findGroupName(roleName);
        try {
            String dn = "cn=" + groupName + "," + this.groupsDn;
            context.unbind(dn);
            this.log.info("deleted group with dn:'{}", (Object)dn);
        }
        catch (LdapException e) {
            throw new MappingException(e.getMessage(), e);
        }
        catch (NamingException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    public void setGroupsDn(String groupsDn) {
        this.groupsDn = groupsDn;
    }

    public void setLdapGroupClass(String ldapGroupClass) {
        this.ldapGroupClass = ldapGroupClass;
    }

    public void setUserConf(UserConfiguration userConf) {
        this.userConf = userConf;
    }

    public void setLdapConnectionFactory(LdapConnectionFactory ldapConnectionFactory) {
        this.ldapConnectionFactory = ldapConnectionFactory;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getLdapGroupMember() {
        return this.ldapGroupMember;
    }

    public void setLdapGroupMember(String ldapGroupMember) {
        this.ldapGroupMember = ldapGroupMember;
    }

    protected String findGroupName(String role) throws MappingException {
        Map<String, Collection<String>> mapping = this.ldapRoleMapperConfiguration.getLdapGroupMappings();
        for (Map.Entry<String, Collection<String>> entry : mapping.entrySet()) {
            if (!entry.getValue().contains(role)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    @Override
    public boolean isUseDefaultRoleName() {
        return this.useDefaultRoleName;
    }

    public void setUseDefaultRoleName(boolean useDefaultRoleName) {
        this.useDefaultRoleName = useDefaultRoleName;
    }
}

