/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.security;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.authentication.AbstractAuthenticator;
import org.apache.archiva.redback.authentication.AuthenticationDataSource;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationFailureCause;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authentication.Authenticator;
import org.apache.archiva.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.UserSecurityPolicy;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="authenticator#archiva")
public class ArchivaUserManagerAuthenticator
extends AbstractAuthenticator
implements Authenticator {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private UserSecurityPolicy securityPolicy;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    private List<UserManager> userManagers;

    @PostConstruct
    public void initialize() throws AuthenticationException {
        try {
            List userManagerImpls = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getUserManagerImpls();
            this.userManagers = new ArrayList<UserManager>(userManagerImpls.size());
            for (String beanId : userManagerImpls) {
                this.userManagers.add((UserManager)this.applicationContext.getBean("userManager#" + beanId, UserManager.class));
            }
        }
        catch (RepositoryAdminException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationResult authenticate(AuthenticationDataSource ds) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        boolean authenticationSuccess = false;
        String username = null;
        Throwable resultException = null;
        PasswordBasedAuthenticationDataSource source = (PasswordBasedAuthenticationDataSource)ds;
        ArrayList<AuthenticationFailureCause> authnResultErrors = new ArrayList<AuthenticationFailureCause>();
        for (UserManager userManager : this.userManagers) {
            try {
                Throwable e;
                this.log.debug("Authenticate: {} with userManager: {}", (Object)source, (Object)userManager.getId());
                User user = userManager.findUser(source.getUsername());
                username = user.getUsername();
                if (user.isLocked()) {
                    e = new AccountLockedException("Account " + source.getUsername() + " is locked.", user);
                    this.log.warn("{}", (Object)e.getMessage());
                    resultException = e;
                    authnResultErrors.add(new AuthenticationFailureCause(3, e.getMessage()));
                }
                if (user.isPasswordChangeRequired() && source.isEnforcePasswordChange()) {
                    e = new MustChangePasswordException("Password expired.", user);
                    this.log.warn("{}", (Object)e.getMessage());
                    resultException = e;
                    authnResultErrors.add(new AuthenticationFailureCause(4, e.getMessage()));
                }
                PasswordEncoder encoder = this.securityPolicy.getPasswordEncoder();
                this.log.debug("PasswordEncoder: {}", (Object)encoder.getClass().getName());
                boolean isPasswordValid = encoder.isPasswordValid(user.getEncodedPassword(), source.getPassword());
                if (isPasswordValid) {
                    this.log.debug("User {} provided a valid password", (Object)source.getUsername());
                    try {
                        this.securityPolicy.extensionPasswordExpiration(user);
                        authenticationSuccess = true;
                        if (user.getCountFailedLoginAttempts() > 0) {
                            user.setCountFailedLoginAttempts(0);
                            if (!userManager.isReadOnly()) {
                                userManager.updateUser(user);
                            }
                        }
                        return new AuthenticationResult(true, source.getUsername(), null);
                    }
                    catch (MustChangePasswordException e2) {
                        user.setPasswordChangeRequired(true);
                        resultException = e2;
                        authnResultErrors.add(new AuthenticationFailureCause(4, e2.getMessage()).user(user));
                        continue;
                    }
                }
                this.log.warn("Password is Invalid for user {} and userManager '{}'.", (Object)source.getUsername(), (Object)userManager.getId());
                authnResultErrors.add(new AuthenticationFailureCause(1, "Password is Invalid for user " + source.getUsername() + ".").user(user));
                try {
                    this.securityPolicy.extensionExcessiveLoginAttempts(user);
                }
                finally {
                    if (userManager.isReadOnly()) continue;
                    userManager.updateUser(user);
                }
            }
            catch (UserNotFoundException e) {
                this.log.warn("Login for user {} and userManager {} failed. user not found.", (Object)source.getUsername(), (Object)userManager.getId());
                resultException = e;
                authnResultErrors.add(new AuthenticationFailureCause(1, "Login for user " + source.getUsername() + " failed. user not found."));
            }
            catch (Exception e) {
                this.log.warn("Login for user {} and userManager {} failed, message: {}", new Object[]{source.getUsername(), userManager.getId(), e.getMessage()});
                resultException = e;
                authnResultErrors.add(new AuthenticationFailureCause(2, "Login for user " + source.getUsername() + " failed, message: " + e.getMessage()));
            }
        }
        return new AuthenticationResult(authenticationSuccess, username, resultException, authnResultErrors);
    }

    public boolean supportsDataSource(AuthenticationDataSource source) {
        return source instanceof PasswordBasedAuthenticationDataSource;
    }

    public String getId() {
        return "ArchivaUserManagerAuthenticator";
    }
}

