/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.rbac.AbstractRBACManager;
import org.apache.archiva.redback.rbac.Operation;
import org.apache.archiva.redback.rbac.Permission;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.RbacObjectInvalidException;
import org.apache.archiva.redback.rbac.RbacObjectNotFoundException;
import org.apache.archiva.redback.rbac.Resource;
import org.apache.archiva.redback.rbac.Role;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="rbacManager#archiva")
public class ArchivaRbacManager
extends AbstractRBACManager
implements RBACManager {
    private Map<String, RBACManager> rbacManagersPerId;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    @Inject
    @Named(value="cache#operations")
    private Cache<String, Operation> operationsCache;
    @Inject
    @Named(value="cache#permissions")
    private Cache<String, Permission> permissionsCache;
    @Inject
    @Named(value="cache#resources")
    private Cache<String, Resource> resourcesCache;
    @Inject
    @Named(value="cache#roles")
    private Cache<String, Role> rolesCache;
    @Inject
    @Named(value="cache#userAssignments")
    private Cache<String, UserAssignment> userAssignmentsCache;
    @Inject
    @Named(value="cache#userPermissions")
    private Cache<String, Map<String, List<Permission>>> userPermissionsCache;
    @Inject
    @Named(value="cache#effectiveRoleSet")
    private Cache<String, Set<Role>> effectiveRoleSetCache;

    public void initialize() {
        try {
            List rbacManagerIds = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getRbacManagerImpls();
            this.log.info("use rbacManagerIds: '{}'", (Object)rbacManagerIds);
            this.rbacManagersPerId = new LinkedHashMap<String, RBACManager>(rbacManagerIds.size());
            for (String id : rbacManagerIds) {
                RBACManager rbacManager = (RBACManager)this.applicationContext.getBean("rbacManager#" + id, RBACManager.class);
                this.rbacManagersPerId.put(id, rbacManager);
            }
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected RBACManager getRbacManagerForWrite() {
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            if (rbacManager.isReadOnly()) continue;
            return rbacManager;
        }
        return this.rbacManagersPerId.values().iterator().next();
    }

    public Role createRole(String name) {
        return this.getRbacManagerForWrite().createRole(name);
    }

    public Role saveRole(Role role) throws RbacObjectInvalidException, RbacManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (rbacManager.isReadOnly()) continue;
                role = rbacManager.saveRole(role);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return role;
    }

    public void saveRoles(Collection<Role> roles) throws RbacObjectInvalidException, RbacManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (rbacManager.isReadOnly()) continue;
                rbacManager.saveRoles(roles);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public Role getRole(String roleName) throws RbacObjectNotFoundException, RbacManagerException {
        Role el = (Role)this.rolesCache.get((Object)roleName);
        if (el != null) {
            return el;
        }
        Exception lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                Role role = rbacManager.getRole(roleName);
                if (role == null) continue;
                this.rolesCache.put((Object)role.getName(), (Object)role);
                return role;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        this.log.debug("cannot find role for name: \u2018{}", (Object)roleName);
        if (lastException != null) {
            throw new RbacManagerException(lastException.getMessage(), (Throwable)lastException);
        }
        return null;
    }

    public List<Role> getAllRoles() throws RbacManagerException {
        HashMap<String, Role> allRoles = new HashMap<String, Role>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List roles = rbacManager.getAllRoles();
                for (Role role : roles) {
                    allRoles.put(role.getName(), role);
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return new ArrayList<Role>(allRoles.values());
    }

    public void removeRole(Role role) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                rbacManager.removeRole(role);
                this.rolesCache.remove((Object)role.getName());
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public Permission createPermission(String name) throws RbacManagerException {
        return this.getRbacManagerForWrite().createPermission(name);
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        return this.getRbacManagerForWrite().createPermission(name, operationName, resourceIdentifier);
    }

    public Permission savePermission(Permission permission) throws RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (!rbacManager.isReadOnly()) continue;
                permission = rbacManager.savePermission(permission);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return permission;
    }

    public Permission getPermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        Permission el = (Permission)this.permissionsCache.get((Object)permissionName);
        if (el != null) {
            return el;
        }
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                Permission p = rbacManager.getPermission(permissionName);
                if (p == null) continue;
                this.permissionsCache.put((Object)permissionName, (Object)p);
                return p;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return null;
    }

    public List<Permission> getAllPermissions() throws RbacManagerException {
        HashMap<String, Permission> allPermissions = new HashMap<String, Permission>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List permissions = rbacManager.getAllPermissions();
                for (Permission p : permissions) {
                    allPermissions.put(p.getName(), p);
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return new ArrayList<Permission>(allPermissions.values());
    }

    public void removePermission(Permission permission) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                rbacManager.removePermission(permission);
                this.permissionsCache.remove((Object)permission.getName());
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public Operation createOperation(String name) throws RbacManagerException {
        return this.getRbacManagerForWrite().createOperation(name);
    }

    public Operation saveOperation(Operation operation) throws RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (rbacManager.isReadOnly()) continue;
                operation = rbacManager.saveOperation(operation);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return operation;
    }

    public Operation getOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        Operation el = (Operation)this.operationsCache.get((Object)operationName);
        if (el != null) {
            return el;
        }
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                Operation o = rbacManager.getOperation(operationName);
                if (o == null) continue;
                this.operationsCache.put((Object)operationName, (Object)o);
                return o;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return null;
    }

    public List<Operation> getAllOperations() throws RbacManagerException {
        HashMap<String, Operation> allOperations = new HashMap<String, Operation>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List operations = rbacManager.getAllOperations();
                for (Operation o : operations) {
                    allOperations.put(o.getName(), o);
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return new ArrayList<Operation>(allOperations.values());
    }

    public void removeOperation(Operation operation) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                rbacManager.removeOperation(operation);
                this.operationsCache.remove((Object)operation.getName());
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        return this.getRbacManagerForWrite().createResource(identifier);
    }

    public Resource saveResource(Resource resource) throws RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (rbacManager.isReadOnly()) continue;
                resource = rbacManager.saveResource(resource);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return resource;
    }

    public Resource getResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        Resource el = (Resource)this.resourcesCache.get((Object)resourceIdentifier);
        if (el != null) {
            return el;
        }
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                Resource r = rbacManager.getResource(resourceIdentifier);
                if (r == null) continue;
                this.resourcesCache.put((Object)resourceIdentifier, (Object)r);
                return r;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return null;
    }

    public List<Resource> getAllResources() throws RbacManagerException {
        HashMap<String, Resource> allResources = new HashMap<String, Resource>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List resources = rbacManager.getAllResources();
                for (Resource r : resources) {
                    allResources.put(r.getIdentifier(), r);
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return new ArrayList<Resource>(allResources.values());
    }

    public void removeResource(Resource resource) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                rbacManager.removeResource(resource);
                this.resourcesCache.remove((Object)resource.getIdentifier());
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public UserAssignment createUserAssignment(String principal) throws RbacManagerException {
        return this.getRbacManagerForWrite().createUserAssignment(principal);
    }

    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (rbacManager.isReadOnly()) continue;
                userAssignment = rbacManager.saveUserAssignment(userAssignment);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return userAssignment;
    }

    public UserAssignment getUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        UserAssignment el = (UserAssignment)this.userAssignmentsCache.get((Object)principal);
        if (el != null) {
            return el;
        }
        UserAssignment ua = null;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                if (ua == null) {
                    ua = rbacManager.getUserAssignment(principal);
                    continue;
                }
                UserAssignment userAssignment = rbacManager.getUserAssignment(principal);
                if (userAssignment == null) continue;
                for (String roleName : userAssignment.getRoleNames()) {
                    ua.addRoleName(roleName);
                }
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (ua != null) {
            this.userAssignmentsCache.put((Object)principal, ua);
            return ua;
        }
        if (lastException != null) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return null;
    }

    public boolean userAssignmentExists(String principal) {
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                boolean exists = rbacManager.userAssignmentExists(principal);
                if (!exists) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    public boolean userAssignmentExists(UserAssignment assignment) {
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                boolean exists = rbacManager.userAssignmentExists(assignment);
                if (!exists) continue;
                return true;
            }
            catch (Exception e) {
            }
        }
        return false;
    }

    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException {
        HashMap<String, UserAssignment> allUserAssignments = new HashMap<String, UserAssignment>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List userAssignments = rbacManager.getAllUserAssignments();
                for (UserAssignment ua : userAssignments) {
                    UserAssignment userAssignment = (UserAssignment)allUserAssignments.get(ua.getPrincipal());
                    if (userAssignment != null) {
                        for (String roleName : ua.getRoleNames()) {
                            userAssignment.addRoleName(roleName);
                        }
                    }
                    allUserAssignments.put(ua.getPrincipal(), ua);
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return new ArrayList<UserAssignment>(allUserAssignments.values());
    }

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> roleNames) throws RbacManagerException {
        ArrayList<UserAssignment> allUserAssignments = new ArrayList<UserAssignment>();
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                List userAssignments = rbacManager.getUserAssignmentsForRoles(roleNames);
                allUserAssignments.addAll(userAssignments);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return allUserAssignments;
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacObjectInvalidException, RbacManagerException {
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                rbacManager.removeUserAssignment(userAssignment);
                this.userAssignmentsCache.remove((Object)userAssignment.getPrincipal());
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
    }

    public boolean roleExists(String name) throws RbacManagerException {
        Role r = (Role)this.rolesCache.get((Object)name);
        if (r != null) {
            return true;
        }
        boolean allFailed = true;
        Throwable lastException = null;
        for (RBACManager rbacManager : this.rbacManagersPerId.values()) {
            try {
                boolean exists = rbacManager.roleExists(name);
                if (!exists) continue;
                return true;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new RbacManagerException(lastException.getMessage(), lastException);
        }
        return false;
    }

    public boolean roleExists(Role role) throws RbacManagerException {
        return this.roleExists(role.getName());
    }

    public void eraseDatabase() {
        this.log.warn("eraseDatabase not implemented");
    }

    public boolean isFinalImplementation() {
        return false;
    }

    public String getDescriptionKey() {
        return "archiva.redback.rbacmanager.archiva";
    }

    public boolean isReadOnly() {
        return false;
    }
}

