/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.security;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.rbac.RBACManager;
import org.apache.archiva.redback.rbac.RbacManagerException;
import org.apache.archiva.redback.rbac.UserAssignment;
import org.apache.archiva.redback.system.check.EnvironmentCheck;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="environmentCheck#archiva-locked-admin-check")
public class ArchivaLockedAdminEnvironmentCheck
implements EnvironmentCheck {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="rbacManager#cached")
    private RBACManager rbacManager;
    private boolean checked = false;
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    private List<UserManager> userManagers;

    @PostConstruct
    protected void initialize() throws RepositoryAdminException {
        List userManagerImpls = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getUserManagerImpls();
        this.userManagers = new ArrayList<UserManager>(userManagerImpls.size());
        for (String beanId : userManagerImpls) {
            this.userManagers.add((UserManager)this.applicationContext.getBean("userManager#" + beanId, UserManager.class));
        }
    }

    public void validateEnvironment(List<String> violations) {
        if (!this.checked) {
            for (UserManager userManager : this.userManagers) {
                if (userManager.isReadOnly()) continue;
                ArrayList<String> roles = new ArrayList<String>();
                roles.add("System Administrator");
                try {
                    List systemAdminstrators = this.rbacManager.getUserAssignmentsForRoles(roles);
                    for (UserAssignment userAssignment : systemAdminstrators) {
                        try {
                            User admin = userManager.findUser(userAssignment.getPrincipal());
                            if (!admin.isLocked()) continue;
                            this.log.info("Unlocking system administrator: {}", (Object)admin.getUsername());
                            admin.setLocked(false);
                            userManager.updateUser(admin);
                        }
                        catch (UserNotFoundException ne) {
                            this.log.warn("Dangling UserAssignment -> {}", (Object)userAssignment.getPrincipal());
                        }
                        catch (UserManagerException e) {
                            this.log.warn("fail to find user {}\u00a0for admin unlock check: {}", (Object)userAssignment.getPrincipal(), (Object)e.getMessage());
                        }
                    }
                }
                catch (RbacManagerException e) {
                    this.log.warn("Exception when checking for locked admin user: {}", (Object)e.getMessage(), (Object)e);
                }
                this.checked = true;
            }
        }
    }
}

