/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.LdapGroupMapping;
import org.apache.archiva.admin.model.beans.RedbackRuntimeConfiguration;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.role.LdapRoleMapperConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ldapRoleMapperConfiguration#archiva")
public class ArchivaLdapRoleMapperConfiguration
implements LdapRoleMapperConfiguration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="redbackRuntimeConfigurationAdmin#default")
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;

    public void addLdapMapping(String ldapGroup, List<String> roles) throws MappingException {
        this.logger.debug("addLdapMapping ldapGroup: {}, roles: {}", (Object)ldapGroup, roles);
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
            boolean added = redbackRuntimeConfiguration.getLdapGroupMappings().add(new LdapGroupMapping(ldapGroup, roles));
            this.logger.debug("addLdapMapping ldapGroup: {}, roles: {}, added: {}", new Object[]{ldapGroup, roles, added});
            this.redbackRuntimeConfigurationAdmin.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
        }
        catch (RepositoryAdminException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateLdapMapping(String ldapGroup, List<String> roles) throws MappingException {
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
            LdapGroupMapping ldapGroupMapping = new LdapGroupMapping(ldapGroup);
            int idx = redbackRuntimeConfiguration.getLdapGroupMappings().indexOf(ldapGroupMapping);
            if (idx > -1) {
                this.logger.debug("updateLdapMapping ldapGroup: {}, roles: {}", (Object)ldapGroup, roles);
                ldapGroupMapping = (LdapGroupMapping)redbackRuntimeConfiguration.getLdapGroupMappings().get(idx);
                ldapGroupMapping.setRoleNames(roles);
            }
            this.redbackRuntimeConfigurationAdmin.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
        }
        catch (RepositoryAdminException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    public void removeLdapMapping(String group) throws MappingException {
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
            boolean removed = redbackRuntimeConfiguration.getLdapGroupMappings().remove(new LdapGroupMapping(group));
            this.redbackRuntimeConfigurationAdmin.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
            this.logger.debug("removeLdapMapping ldapGroup: {}, removed: {}", (Object)group, (Object)removed);
        }
        catch (RepositoryAdminException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Collection<String>> getLdapGroupMappings() throws MappingException {
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
            List ldapGroupMappings = redbackRuntimeConfiguration.getLdapGroupMappings();
            if (ldapGroupMappings == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Collection<String>> res = new HashMap<String, Collection<String>>(ldapGroupMappings.size());
            for (LdapGroupMapping ldapGroupMapping : ldapGroupMappings) {
                res.put(ldapGroupMapping.getGroup(), ldapGroupMapping.getRoleNames());
            }
            return res;
        }
        catch (RepositoryAdminException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }

    public void setLdapGroupMappings(Map<String, List<String>> mappings) throws MappingException {
        try {
            RedbackRuntimeConfiguration redbackRuntimeConfiguration = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration();
            ArrayList<LdapGroupMapping> ldapGroupMappings = new ArrayList<LdapGroupMapping>(mappings.size());
            for (Map.Entry<String, List<String>> entry : mappings.entrySet()) {
                ldapGroupMappings.add(new LdapGroupMapping(entry.getKey(), (Collection)entry.getValue()));
            }
            redbackRuntimeConfiguration.setLdapGroupMappings(ldapGroupMappings);
            this.redbackRuntimeConfigurationAdmin.updateRedbackRuntimeConfiguration(redbackRuntimeConfiguration);
        }
        catch (RepositoryAdminException e) {
            throw new MappingException(e.getMessage(), (Throwable)e);
        }
    }
}

