/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.security;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.runtime.RedbackRuntimeConfigurationAdmin;
import org.apache.archiva.redback.components.cache.Cache;
import org.apache.archiva.redback.users.AbstractUserManager;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.redback.users.UserQuery;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="userManager#archiva")
public class ArchivaConfigurableUsersManager
extends AbstractUserManager {
    @Inject
    private RedbackRuntimeConfigurationAdmin redbackRuntimeConfigurationAdmin;
    @Inject
    private ApplicationContext applicationContext;
    private Map<String, UserManager> userManagerPerId;
    @Inject
    @Named(value="cache#users")
    private Cache<String, User> usersCache;
    private boolean useUsersCache;

    @PostConstruct
    public void initialize() {
        try {
            List userManagerImpls = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().getUserManagerImpls();
            this.log.info("use userManagerImpls: '{}'", (Object)userManagerImpls);
            this.userManagerPerId = new LinkedHashMap<String, UserManager>(userManagerImpls.size());
            for (String id : userManagerImpls) {
                UserManager userManagerImpl = (UserManager)this.applicationContext.getBean("userManager#" + id, UserManager.class);
                this.setUserManagerImpl(userManagerImpl);
                this.userManagerPerId.put(id, userManagerImpl);
            }
            this.useUsersCache = this.redbackRuntimeConfigurationAdmin.getRedbackRuntimeConfiguration().isUseUsersCache();
        }
        catch (RepositoryAdminException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected boolean useUsersCache() {
        return this.useUsersCache;
    }

    public User addUser(User user) throws UserManagerException {
        user = this.userManagerPerId.get(user.getUserManagerId()).addUser(user);
        if (this.useUsersCache()) {
            this.usersCache.put((Object)user.getUsername(), (Object)user);
        }
        return user;
    }

    public void addUserUnchecked(User user) throws UserManagerException {
        this.userManagerPerId.get(user.getUserManagerId()).addUserUnchecked(user);
        if (this.useUsersCache()) {
            this.usersCache.put((Object)user.getUsername(), (Object)user);
        }
    }

    public User createUser(String username, String fullName, String emailAddress) throws UserManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        User user = null;
        for (UserManager userManager : this.userManagerPerId.values()) {
            try {
                if (userManager.isReadOnly()) continue;
                user = userManager.createUser(username, fullName, emailAddress);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new UserManagerException(lastException.getMessage(), lastException);
        }
        return user;
    }

    public UserQuery createUserQuery() {
        return this.userManagerPerId.values().iterator().next().createUserQuery();
    }

    public void deleteUser(String username) throws UserNotFoundException, UserManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        Object user = null;
        for (UserManager userManager : this.userManagerPerId.values()) {
            try {
                if (userManager.isReadOnly()) continue;
                userManager.deleteUser(username);
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new UserManagerException(lastException.getMessage(), lastException);
        }
    }

    public void eraseDatabase() {
        for (UserManager userManager : this.userManagerPerId.values()) {
            userManager.eraseDatabase();
        }
    }

    public User findUser(String username, boolean useCache) throws UserNotFoundException, UserManagerException {
        User user = null;
        if (this.useUsersCache() && useCache && (user = (User)this.usersCache.get((Object)username)) != null) {
            return user;
        }
        Throwable lastException = null;
        for (UserManager userManager : this.userManagerPerId.values()) {
            try {
                user = userManager.findUser(username);
                if (user == null) continue;
                if (this.useUsersCache()) {
                    this.usersCache.put((Object)username, (Object)user);
                }
                return user;
            }
            catch (UserNotFoundException e) {
                lastException = e;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (user == null && lastException != null) {
            if (lastException instanceof UserNotFoundException) {
                throw lastException;
            }
            throw new UserManagerException(lastException.getMessage(), lastException);
        }
        return user;
    }

    public User findUser(String username) throws UserManagerException {
        return this.findUser(username, this.useUsersCache());
    }

    public User getGuestUser() throws UserNotFoundException, UserManagerException {
        return this.findUser("guest");
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.findUsersByEmailKey(emailKey, orderAscending);
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.findUsersByFullNameKey(fullNameKey, orderAscending);
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public List<User> findUsersByQuery(UserQuery query) throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.findUsersByQuery(query);
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.findUsersByUsernameKey(usernameKey, orderAscending);
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public String getId() {
        return null;
    }

    public List<User> getUsers() throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.getUsers();
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public List<User> getUsers(boolean orderAscending) throws UserManagerException {
        ArrayList<User> users = new ArrayList<User>();
        for (UserManager userManager : this.userManagerPerId.values()) {
            List found = userManager.getUsers(orderAscending);
            if (found == null) continue;
            users.addAll(found);
        }
        return users;
    }

    public boolean isReadOnly() {
        boolean readOnly = false;
        for (UserManager userManager : this.userManagerPerId.values()) {
            readOnly = readOnly || userManager.isReadOnly();
        }
        return readOnly;
    }

    public User updateUser(User user) throws UserNotFoundException, UserManagerException {
        UserManager userManager = this.userManagerPerId.get(user.getUserManagerId());
        user = userManager.updateUser(user);
        if (this.useUsersCache()) {
            this.usersCache.put((Object)user.getUsername(), (Object)user);
        }
        return user;
    }

    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException, UserManagerException {
        user = this.userManagerPerId.get(user.getUserManagerId()).updateUser(user, passwordChangeRequired);
        if (this.useUsersCache()) {
            this.usersCache.put((Object)user.getUsername(), (Object)user);
        }
        return user;
    }

    public void setUserManagerImpl(UserManager userManagerImpl) {
        this.log.debug("setUserManagerImpl cannot be used in this implementation");
    }

    public User createGuestUser() throws UserManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        User user = null;
        for (UserManager userManager : this.userManagerPerId.values()) {
            try {
                if (userManager.isReadOnly()) continue;
                user = userManager.createGuestUser();
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new UserManagerException(lastException.getMessage(), lastException);
        }
        return user;
    }

    public boolean userExists(String userName) throws UserManagerException {
        Throwable lastException = null;
        boolean allFailed = true;
        boolean exists = false;
        for (UserManager userManager : this.userManagerPerId.values()) {
            try {
                if (userManager.userExists(userName)) {
                    exists = true;
                }
                allFailed = false;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null && allFailed) {
            throw new UserManagerException(lastException.getMessage(), lastException);
        }
        return exists;
    }

    public boolean isFinalImplementation() {
        return false;
    }

    public String getDescriptionKey() {
        return "archiva.redback.usermanager.configurable.archiva";
    }
}

