/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.docs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDocsServlet
extends HttpServlet {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.debug("docs request to path: {}", (Object)req.getPathInfo());
        String path = StringUtils.removeStart((String)req.getPathInfo(), (String)"/");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (StringUtils.endsWith((String)path, (String)".xsd")) {
            StringEscapeUtils.escapeXml((Writer)resp.getWriter(), (String)IOUtils.toString((InputStream)is));
            return;
        }
        String startPath = StringUtils.substringBefore((String)path, (String)"/");
        Document document = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"");
        Element body = document.body().child(0);
        Elements links = body.select("a[href]");
        for (Element link : links) {
            link.attr("href", "#" + startPath + "/" + link.attr("href"));
        }
        Elements codes = body.select("code");
        for (Element code : codes) {
            code.attr("class", code.attr("class") + " nice-code");
        }
        Elements headers = body.select("h1");
        for (Element header : headers) {
            header.tagName("h3");
        }
        headers = body.select("h2");
        for (Element header : headers) {
            header.tagName("h4");
        }
        headers = body.select("h3");
        for (Element header : headers) {
            header.tagName("h5");
        }
        Document res = new Document("");
        res.appendChild((Node)body.select("div[id=main]").first());
        resp.getOutputStream().write(res.outerHtml().getBytes());
    }
}

