/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.web.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.admin.ArchivaAdministration;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.admin.model.managed.ManagedRepositoryAdmin;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.redback.components.taskqueue.Task;
import org.apache.archiva.redback.components.taskqueue.TaskQueueException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RepositoryContentFactory;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.RepositoryNotFoundException;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.scheduler.ArchivaTaskScheduler;
import org.apache.archiva.scheduler.repository.model.RepositoryTask;
import org.apache.archiva.web.api.FileUploadService;
import org.apache.archiva.web.model.FileMetadata;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="fileUploadService#rest")
public class DefaultFileUploadService
extends AbstractRestService
implements FileUploadService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private ManagedRepositoryAdmin managedRepositoryAdmin;
    @Inject
    private RepositoryContentFactory repositoryFactory;
    @Inject
    private ArchivaAdministration archivaAdministration;
    private ChecksumAlgorithm[] algorithms = new ChecksumAlgorithm[]{ChecksumAlgorithm.SHA1, ChecksumAlgorithm.MD5};
    @Inject
    @Named(value="archivaTaskScheduler#repository")
    private ArchivaTaskScheduler scheduler;

    private String getStringValue(MultipartBody multipartBody, String attachmentId) throws IOException {
        Attachment attachment = multipartBody.getAttachment(attachmentId);
        return attachment == null ? "" : IOUtils.toString((InputStream)attachment.getDataHandler().getInputStream());
    }

    @Override
    public FileMetadata post(MultipartBody multipartBody) throws ArchivaRestServiceException {
        try {
            String classifier = this.getStringValue(multipartBody, "classifier");
            String packaging = this.getStringValue(multipartBody, "packaging");
            boolean pomFile = BooleanUtils.toBoolean((String)this.getStringValue(multipartBody, "pomFile"));
            Attachment file = multipartBody.getAttachment("files[]");
            String fileName = file.getContentDisposition().getParameter("filename");
            File tmpFile = File.createTempFile("upload-artifact", ".tmp");
            tmpFile.deleteOnExit();
            IOUtils.copy((InputStream)file.getDataHandler().getInputStream(), (OutputStream)new FileOutputStream(tmpFile));
            FileMetadata fileMetadata = new FileMetadata(fileName, tmpFile.length(), "theurl");
            fileMetadata.setServerFileName(tmpFile.getPath());
            fileMetadata.setClassifier(classifier);
            fileMetadata.setDeleteUrl(tmpFile.getName());
            fileMetadata.setPomFile(pomFile);
            fileMetadata.setPackaging(packaging);
            this.log.info("uploading file: {}", (Object)fileMetadata);
            List<FileMetadata> fileMetadatas = this.getSessionFilesList();
            fileMetadatas.add(fileMetadata);
            return fileMetadata;
        }
        catch (IOException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    protected synchronized List<FileMetadata> getSessionFilesList() {
        CopyOnWriteArrayList fileMetadatas = (CopyOnWriteArrayList)this.httpServletRequest.getSession().getAttribute(FILES_SESSION_KEY);
        if (fileMetadatas == null) {
            fileMetadatas = new CopyOnWriteArrayList();
            this.httpServletRequest.getSession().setAttribute(FILES_SESSION_KEY, fileMetadatas);
        }
        return fileMetadatas;
    }

    @Override
    public Boolean deleteFile(String fileName) throws ArchivaRestServiceException {
        File file = new File(SystemUtils.getJavaIoTmpDir(), fileName);
        this.log.debug("delete file:{},exists:{}", (Object)file.getPath(), (Object)file.exists());
        boolean removed = this.getSessionFileMetadatas().remove(new FileMetadata(fileName));
        if (!removed) {
            removed = this.getSessionFileMetadatas().remove(new FileMetadata(file.getPath()));
        }
        if (file.exists()) {
            return file.delete();
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean clearUploadedFiles() throws ArchivaRestServiceException {
        ArrayList<FileMetadata> fileMetadatas = new ArrayList<FileMetadata>(this.getSessionFileMetadatas());
        for (FileMetadata fileMetadata : fileMetadatas) {
            this.deleteFile(new File(fileMetadata.getServerFileName()).getPath());
        }
        this.getSessionFileMetadatas().clear();
        return Boolean.TRUE;
    }

    @Override
    public List<FileMetadata> getSessionFileMetadatas() throws ArchivaRestServiceException {
        List fileMetadatas = (List)this.httpServletRequest.getSession().getAttribute(FILES_SESSION_KEY);
        return fileMetadatas == null ? Collections.emptyList() : fileMetadatas;
    }

    @Override
    public Boolean save(String repositoryId, String groupId, String artifactId, String version, String packaging, boolean generatePom) throws ArchivaRestServiceException {
        repositoryId = StringUtils.trim((String)repositoryId);
        groupId = StringUtils.trim((String)groupId);
        artifactId = StringUtils.trim((String)artifactId);
        version = StringUtils.trim((String)version);
        packaging = StringUtils.trim((String)packaging);
        List<FileMetadata> fileMetadatas = this.getSessionFilesList();
        if (fileMetadatas == null || fileMetadatas.isEmpty()) {
            return Boolean.FALSE;
        }
        try {
            ManagedRepository managedRepository = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            if (managedRepository == null) {
                throw new ArchivaRestServiceException("Cannot find managed repository with id " + repositoryId, Response.Status.BAD_REQUEST.getStatusCode(), null);
            }
            if (VersionUtil.isSnapshot((String)version) && !managedRepository.isSnapshots()) {
                throw new ArchivaRestServiceException("Managed repository with id " + repositoryId + " do not accept snapshots", Response.Status.BAD_REQUEST.getStatusCode(), null);
            }
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
        Iterable filesToAdd = Iterables.filter(fileMetadatas, (Predicate)new Predicate<FileMetadata>(){

            public boolean apply(FileMetadata fileMetadata) {
                return fileMetadata != null && !fileMetadata.isPomFile();
            }
        });
        Iterator iterator = filesToAdd.iterator();
        boolean pomGenerated = false;
        while (iterator.hasNext()) {
            FileMetadata fileMetadata = (FileMetadata)iterator.next();
            this.log.debug("fileToAdd: {}", (Object)fileMetadata);
            this.saveFile(repositoryId, fileMetadata, generatePom && !pomGenerated, groupId, artifactId, version, packaging);
            pomGenerated = true;
            this.deleteFile(fileMetadata.getServerFileName());
        }
        filesToAdd = Iterables.filter(fileMetadatas, (Predicate)new Predicate<FileMetadata>(){

            public boolean apply(FileMetadata fileMetadata) {
                return fileMetadata != null && fileMetadata.isPomFile();
            }
        });
        for (FileMetadata fileMetadata : filesToAdd) {
            this.log.debug("fileToAdd: {}", (Object)fileMetadata);
            this.savePomFile(repositoryId, fileMetadata, groupId, artifactId, version, packaging);
            this.deleteFile(fileMetadata.getServerFileName());
        }
        return Boolean.TRUE;
    }

    protected void savePomFile(String repositoryId, FileMetadata fileMetadata, String groupId, String artifactId, String version, String packaging) throws ArchivaRestServiceException {
        try {
            boolean fixChecksums = !this.archivaAdministration.getKnownContentConsumers().contains("create-missing-checksums");
            ManagedRepository repoConfig = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            ArtifactReference artifactReference = new ArtifactReference();
            artifactReference.setArtifactId(artifactId);
            artifactReference.setGroupId(groupId);
            artifactReference.setVersion(version);
            artifactReference.setClassifier(fileMetadata.getClassifier());
            artifactReference.setType(packaging);
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            String artifactPath = repository.toPath(artifactReference);
            int lastIndex = artifactPath.lastIndexOf(47);
            String path = artifactPath.substring(0, lastIndex);
            File targetPath = new File(repoConfig.getLocation(), path);
            String pomFilename = artifactPath.substring(lastIndex + 1);
            if (StringUtils.isNotEmpty((String)fileMetadata.getClassifier())) {
                pomFilename = StringUtils.remove((String)pomFilename, (String)("-" + fileMetadata.getClassifier()));
            }
            pomFilename = FilenameUtils.removeExtension((String)pomFilename) + ".pom";
            this.copyFile(new File(fileMetadata.getServerFileName()), targetPath, pomFilename, fixChecksums);
            this.triggerAuditEvent(repoConfig.getId(), path + "/" + pomFilename, "Uploaded File");
            this.queueRepositoryTask(repoConfig.getId(), new File(targetPath, pomFilename));
        }
        catch (IOException ie) {
            throw new ArchivaRestServiceException("Error encountered while uploading pom file: " + ie.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)ie);
        }
        catch (RepositoryException rep) {
            throw new ArchivaRestServiceException("Repository exception: " + rep.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)rep);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException("RepositoryAdmin exception: " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    protected void saveFile(String repositoryId, FileMetadata fileMetadata, boolean generatePom, String groupId, String artifactId, String version, String packaging) throws ArchivaRestServiceException {
        try {
            ManagedRepository repoConfig = this.managedRepositoryAdmin.getManagedRepository(repositoryId);
            ArtifactReference artifactReference = new ArtifactReference();
            artifactReference.setArtifactId(artifactId);
            artifactReference.setGroupId(groupId);
            artifactReference.setVersion(version);
            artifactReference.setClassifier(fileMetadata.getClassifier());
            artifactReference.setType(StringUtils.isEmpty((String)fileMetadata.getPackaging()) ? packaging : fileMetadata.getPackaging());
            ManagedRepositoryContent repository = this.repositoryFactory.getManagedRepositoryContent(repositoryId);
            String artifactPath = repository.toPath(artifactReference);
            int lastIndex = artifactPath.lastIndexOf(47);
            String path = artifactPath.substring(0, lastIndex);
            File targetPath = new File(repoConfig.getLocation(), path);
            this.log.debug("artifactPath: {} found targetPath: {}", (Object)artifactPath, (Object)targetPath);
            Date lastUpdatedTimestamp = Calendar.getInstance().getTime();
            int newBuildNumber = -1;
            String timestamp = null;
            File versionMetadataFile = new File(targetPath, "maven-metadata.xml");
            ArchivaRepositoryMetadata versionMetadata = this.getMetadata(versionMetadataFile);
            if (VersionUtil.isSnapshot((String)version)) {
                TimeZone timezone = TimeZone.getTimeZone("UTC");
                SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd.HHmmss");
                fmt.setTimeZone(timezone);
                timestamp = fmt.format(lastUpdatedTimestamp);
                newBuildNumber = versionMetadata.getSnapshotVersion() != null ? versionMetadata.getSnapshotVersion().getBuildNumber() + 1 : 1;
            }
            if (!targetPath.exists()) {
                targetPath.mkdirs();
            }
            String filename = artifactPath.substring(lastIndex + 1);
            if (VersionUtil.isSnapshot((String)version)) {
                filename = filename.replaceAll("SNAPSHOT", timestamp + "-" + newBuildNumber);
            }
            boolean fixChecksums = !this.archivaAdministration.getKnownContentConsumers().contains("create-missing-checksums");
            try {
                File targetFile = new File(targetPath, filename);
                if (targetFile.exists() && !VersionUtil.isSnapshot((String)version) && repoConfig.isBlockRedeployments()) {
                    throw new ArchivaRestServiceException("Overwriting released artifacts in repository '" + repoConfig.getId() + "' is not allowed.", Response.Status.BAD_REQUEST.getStatusCode(), null);
                }
                this.copyFile(new File(fileMetadata.getServerFileName()), targetPath, filename, fixChecksums);
                this.triggerAuditEvent(repository.getId(), path + "/" + filename, "Uploaded File");
                this.queueRepositoryTask(repository.getId(), targetFile);
            }
            catch (IOException ie) {
                this.log.error("IOException copying file: {}", (Object)ie.getMessage(), (Object)ie);
                throw new ArchivaRestServiceException("Overwriting released artifacts in repository '" + repoConfig.getId() + "' is not allowed.", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)ie);
            }
            if (generatePom) {
                String pomFilename = filename;
                if (StringUtils.isNotEmpty((String)fileMetadata.getClassifier())) {
                    pomFilename = StringUtils.remove((String)pomFilename, (String)("-" + fileMetadata.getClassifier()));
                }
                pomFilename = FilenameUtils.removeExtension((String)pomFilename) + ".pom";
                try {
                    File generatedPomFile = this.createPom(targetPath, pomFilename, fileMetadata, groupId, artifactId, version, packaging);
                    this.triggerAuditEvent(repoConfig.getId(), path + "/" + pomFilename, "Uploaded File");
                    if (fixChecksums) {
                        this.fixChecksums(generatedPomFile);
                    }
                    this.queueRepositoryTask(repoConfig.getId(), generatedPomFile);
                }
                catch (IOException ie) {
                    throw new ArchivaRestServiceException("Error encountered while writing pom file: " + ie.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)ie);
                }
            }
            if (!this.archivaAdministration.getKnownContentConsumers().contains("metadata-updater")) {
                this.updateProjectMetadata(targetPath.getAbsolutePath(), lastUpdatedTimestamp, timestamp, newBuildNumber, fixChecksums, fileMetadata, groupId, artifactId, version, packaging);
                if (VersionUtil.isSnapshot((String)version)) {
                    this.updateVersionMetadata(versionMetadata, versionMetadataFile, lastUpdatedTimestamp, timestamp, newBuildNumber, fixChecksums, fileMetadata, groupId, artifactId, version, packaging);
                }
            }
        }
        catch (RepositoryNotFoundException re) {
            throw new ArchivaRestServiceException("Target repository cannot be found: " + re.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)re);
        }
        catch (RepositoryException rep) {
            throw new ArchivaRestServiceException("Repository exception: " + rep.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)rep);
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException("RepositoryAdmin exception: " + e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Throwable)e);
        }
    }

    private ArchivaRepositoryMetadata getMetadata(File metadataFile) throws RepositoryMetadataException {
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        if (metadataFile.exists()) {
            try {
                metadata = MavenMetadataReader.read((File)metadataFile);
            }
            catch (XMLException e) {
                throw new RepositoryMetadataException(e.getMessage(), (Throwable)e);
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPom(File targetPath, String filename, FileMetadata fileMetadata, String groupId, String artifactId, String version, String packaging) throws IOException {
        Model projectModel = new Model();
        projectModel.setModelVersion("4.0.0");
        projectModel.setGroupId(groupId);
        projectModel.setArtifactId(artifactId);
        projectModel.setVersion(version);
        projectModel.setPackaging(packaging);
        File pomFile = new File(targetPath, filename);
        MavenXpp3Writer writer = new MavenXpp3Writer();
        FileWriter w = new FileWriter(pomFile);
        try {
            writer.write((Writer)w, projectModel);
        }
        finally {
            IOUtils.closeQuietly((Writer)w);
        }
        return pomFile;
    }

    private void fixChecksums(File file) {
        ChecksummedFile checksum = new ChecksummedFile(file);
        checksum.fixChecksums(this.algorithms);
    }

    private void queueRepositoryTask(String repositoryId, File localFile) {
        RepositoryTask task = new RepositoryTask();
        task.setRepositoryId(repositoryId);
        task.setResourceFile(localFile);
        task.setUpdateRelatedArtifacts(true);
        task.setScanAll(false);
        try {
            this.scheduler.queueTask((Task)task);
        }
        catch (TaskQueueException e) {
            this.log.error("Unable to queue repository task to execute consumers on resource file ['" + localFile.getName() + "'].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File targetPath, String targetFilename, boolean fixChecksums) throws IOException {
        FileOutputStream out = null;
        FileInputStream input = null;
        try {
            out = new FileOutputStream(new File(targetPath, targetFilename));
            input = new FileInputStream(sourceFile);
            IOUtils.copy((InputStream)input, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)input);
        if (fixChecksums) {
            this.fixChecksums(new File(targetPath, targetFilename));
        }
    }

    private void updateProjectMetadata(String targetPath, Date lastUpdatedTimestamp, String timestamp, int buildNumber, boolean fixChecksums, FileMetadata fileMetadata, String groupId, String artifactId, String version, String packaging) throws RepositoryMetadataException {
        List<String> availableVersions = new ArrayList<String>();
        String latestVersion = version;
        File projectDir = new File(targetPath).getParentFile();
        File projectMetadataFile = new File(projectDir, "maven-metadata.xml");
        ArchivaRepositoryMetadata projectMetadata = this.getMetadata(projectMetadataFile);
        if (projectMetadataFile.exists()) {
            availableVersions = projectMetadata.getAvailableVersions();
            Collections.sort(availableVersions, VersionComparator.getInstance());
            if (!availableVersions.contains(version)) {
                availableVersions.add(version);
            }
            latestVersion = (String)availableVersions.get(availableVersions.size() - 1);
        } else {
            availableVersions.add(version);
            projectMetadata.setGroupId(groupId);
            projectMetadata.setArtifactId(artifactId);
        }
        if (projectMetadata.getGroupId() == null) {
            projectMetadata.setGroupId(groupId);
        }
        if (projectMetadata.getArtifactId() == null) {
            projectMetadata.setArtifactId(artifactId);
        }
        projectMetadata.setLatestVersion(latestVersion);
        projectMetadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        projectMetadata.setAvailableVersions(availableVersions);
        if (!VersionUtil.isSnapshot((String)version)) {
            projectMetadata.setReleasedVersion(latestVersion);
        }
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)projectMetadata, (File)projectMetadataFile);
        if (fixChecksums) {
            this.fixChecksums(projectMetadataFile);
        }
    }

    private void updateVersionMetadata(ArchivaRepositoryMetadata metadata, File metadataFile, Date lastUpdatedTimestamp, String timestamp, int buildNumber, boolean fixChecksums, FileMetadata fileMetadata, String groupId, String artifactId, String version, String packaging) throws RepositoryMetadataException {
        if (!metadataFile.exists()) {
            metadata.setGroupId(groupId);
            metadata.setArtifactId(artifactId);
            metadata.setVersion(version);
        }
        if (metadata.getSnapshotVersion() == null) {
            metadata.setSnapshotVersion(new SnapshotVersion());
        }
        metadata.getSnapshotVersion().setBuildNumber(buildNumber);
        metadata.getSnapshotVersion().setTimestamp(timestamp);
        metadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)metadata, (File)metadataFile);
        if (fixChecksums) {
            this.fixChecksums(metadataFile);
        }
    }
}

