/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.List;
import javax.inject.Inject;
import org.apache.archiva.admin.model.RepositoryAdminException;
import org.apache.archiva.admin.model.beans.ProxyConnectorRule;
import org.apache.archiva.admin.model.proxyconnectorrule.ProxyConnectorRuleAdmin;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.ProxyConnectorRuleService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="proxyConnectorRuleService#rest")
public class DefaultProxyConnectorRuleService
extends AbstractRestService
implements ProxyConnectorRuleService {
    @Inject
    private ProxyConnectorRuleAdmin proxyConnectorRuleAdmin;

    public List<ProxyConnectorRule> getProxyConnectorRules() throws ArchivaRestServiceException {
        try {
            return this.proxyConnectorRuleAdmin.getProxyConnectorRules();
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateProxyConnectorRule(ProxyConnectorRule proxyConnectorRule) throws ArchivaRestServiceException {
        if (StringUtils.isEmpty((String)proxyConnectorRule.getPattern())) {
            ArchivaRestServiceException e = new ArchivaRestServiceException("pattern cannot be empty", null);
            e.setErrorKey("proxy-connector-rule.pattern.empty");
            throw e;
        }
        if (proxyConnectorRule.getProxyConnectors() == null || proxyConnectorRule.getProxyConnectors().isEmpty()) {
            ArchivaRestServiceException e = new ArchivaRestServiceException("proxyConnector rule must have proxyConnectors.", null);
            e.setErrorKey("proxy-connector-rule.pattern.connectors.empty");
            throw e;
        }
        for (ProxyConnectorRule proxyConnectorRule1 : this.getProxyConnectorRules()) {
            if (!StringUtils.equals((String)proxyConnectorRule.getPattern(), (String)proxyConnectorRule1.getPattern()) || proxyConnectorRule.getProxyConnectorRuleType() != proxyConnectorRule1.getProxyConnectorRuleType()) continue;
            ArchivaRestServiceException e = new ArchivaRestServiceException("same ProxyConnector rule already exists.", null);
            e.setErrorKey("proxy-connector-rule.pattern.already.exists");
            throw e;
        }
    }

    public Boolean addProxyConnectorRule(ProxyConnectorRule proxyConnectorRule) throws ArchivaRestServiceException {
        this.validateProxyConnectorRule(proxyConnectorRule);
        try {
            this.proxyConnectorRuleAdmin.addProxyConnectorRule(proxyConnectorRule, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean deleteProxyConnectorRule(ProxyConnectorRule proxyConnectorRule) throws ArchivaRestServiceException {
        try {
            this.proxyConnectorRuleAdmin.deleteProxyConnectorRule(proxyConnectorRule, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Boolean updateProxyConnectorRule(ProxyConnectorRule proxyConnectorRule) throws ArchivaRestServiceException {
        try {
            this.proxyConnectorRuleAdmin.updateProxyConnectorRule(proxyConnectorRule, this.getAuditInformation());
            return Boolean.TRUE;
        }
        catch (RepositoryAdminException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }
}

