/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.rest.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.maven2.model.Artifact;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.filter.Filter;
import org.apache.archiva.metadata.repository.filter.IncludesFilter;
import org.apache.archiva.rest.api.services.ArchivaRestServiceException;
import org.apache.archiva.rest.api.services.MergeRepositoriesService;
import org.apache.archiva.rest.services.AbstractRestService;
import org.apache.archiva.stagerepository.merge.Maven2RepositoryMerger;
import org.apache.archiva.stagerepository.merge.RepositoryMergerException;
import org.springframework.stereotype.Service;

@Service(value="mergeRepositoriesService#rest")
public class DefaultMergeRepositoriesService
extends AbstractRestService
implements MergeRepositoriesService {
    @Inject
    @Named(value="repositoryMerger#maven2")
    private Maven2RepositoryMerger repositoryMerger;

    public List<Artifact> getMergeConflictedArtifacts(String sourceRepositoryId, String targetRepositoryId) throws ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List artifactMetadatas = this.repositoryMerger.getConflictingArtifacts(repositorySession.getRepository(), sourceRepositoryId, targetRepositoryId);
            List<Artifact> list = this.buildArtifacts(artifactMetadatas, sourceRepositoryId);
            return list;
        }
    }

    public void mergeRepositories(String sourceRepositoryId, String targetRepositoryId, boolean skipConflicts) throws ArchivaRestServiceException {
        try {
            if (skipConflicts) {
                this.mergeBySkippingConflicts(sourceRepositoryId, targetRepositoryId);
            } else {
                this.doMerge(sourceRepositoryId, targetRepositoryId);
            }
        }
        catch (RepositoryMergerException e) {
            throw new ArchivaRestServiceException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doMerge(String sourceRepositoryId, String targetRepositoryId) throws RepositoryMergerException, ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            ManagedRepository repository = this.managedRepositoryAdmin.getManagedRepository(targetRepositoryId);
            MetadataRepository metadataRepository = repositorySession.getRepository();
            List sourceArtifacts = metadataRepository.getArtifacts(sourceRepositoryId);
            if (repository.isReleases() && !repository.isSnapshots()) {
                this.mergeWithOutSnapshots(metadataRepository, sourceArtifacts, sourceRepositoryId, targetRepositoryId);
            } else {
                this.repositoryMerger.merge(metadataRepository, sourceRepositoryId, targetRepositoryId);
                for (ArtifactMetadata metadata : sourceArtifacts) {
                    this.triggerAuditEvent(targetRepositoryId, metadata.getId(), "Merged Artifact");
                }
            }
            this.doScanRepository(targetRepositoryId, false);
        }
    }

    public void mergeBySkippingConflicts(String sourceRepositoryId, String targetRepositoryId) throws RepositoryMergerException, ArchivaRestServiceException {
        try (RepositorySession repositorySession = this.repositorySessionFactory.createSession();){
            List conflictSourceArtifacts = this.repositoryMerger.getConflictingArtifacts(repositorySession.getRepository(), sourceRepositoryId, targetRepositoryId);
            MetadataRepository metadataRepository = repositorySession.getRepository();
            List sourceArtifacts = metadataRepository.getArtifacts(sourceRepositoryId);
            sourceArtifacts.removeAll(conflictSourceArtifacts);
            ManagedRepository repository = this.managedRepositoryAdmin.getManagedRepository(targetRepositoryId);
            if (repository.isReleases() && !repository.isSnapshots()) {
                this.mergeWithOutSnapshots(metadataRepository, sourceArtifacts, sourceRepositoryId, targetRepositoryId);
            } else {
                IncludesFilter artifactsWithOutConflicts = new IncludesFilter((Collection)sourceArtifacts);
                this.repositoryMerger.merge(metadataRepository, sourceRepositoryId, targetRepositoryId, (Filter)artifactsWithOutConflicts);
                for (ArtifactMetadata metadata : sourceArtifacts) {
                    this.triggerAuditEvent(targetRepositoryId, metadata.getId(), "Merged Artifact");
                }
            }
            this.doScanRepository(targetRepositoryId, false);
        }
    }

    private void mergeWithOutSnapshots(MetadataRepository metadataRepository, List<ArtifactMetadata> sourceArtifacts, String sourceRepoId, String repoid) throws RepositoryMergerException {
        ArrayList<ArtifactMetadata> artifactsWithOutSnapshots = new ArrayList<ArtifactMetadata>();
        for (ArtifactMetadata metadata : sourceArtifacts) {
            if (VersionUtil.isSnapshot((String)metadata.getProjectVersion())) {
                artifactsWithOutSnapshots.add(metadata);
                continue;
            }
            this.triggerAuditEvent(repoid, metadata.getId(), "Merged Artifact");
        }
        sourceArtifacts.removeAll(artifactsWithOutSnapshots);
        IncludesFilter artifactListWithOutSnapShots = new IncludesFilter(sourceArtifacts);
        this.repositoryMerger.merge(metadataRepository, sourceRepoId, repoid, (Filter)artifactListWithOutSnapShots);
    }
}

