/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.metadata;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.common.utils.PathUtil;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.ArtifactReference;
import org.apache.archiva.model.ProjectReference;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.model.VersionedReference;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.archiva.repository.ContentNotFoundException;
import org.apache.archiva.repository.ManagedRepositoryContent;
import org.apache.archiva.repository.RemoteRepositoryContent;
import org.apache.archiva.repository.layout.LayoutException;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataMerge;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="metadataTools#default")
public class MetadataTools
implements RegistryListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String MAVEN_METADATA = "maven-metadata.xml";
    public static final String MAVEN_ARCHETYPE_CATALOG = "archetype-catalog.xml";
    private static final char PATH_SEPARATOR = '/';
    private static final char GROUP_SEPARATOR = '.';
    @Inject
    @Named(value="archivaConfiguration#default")
    private ArchivaConfiguration configuration;
    @Inject
    @Named(value="fileTypes")
    private FileTypes filetypes;
    private ChecksumAlgorithm[] algorithms = new ChecksumAlgorithm[]{ChecksumAlgorithm.SHA1, ChecksumAlgorithm.MD5};
    private List<String> artifactPatterns;
    private Map<String, Set<String>> proxies;
    private static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private SimpleDateFormat lastUpdatedFormat = new SimpleDateFormat("yyyyMMddHHmmss");

    public MetadataTools() {
        this.lastUpdatedFormat.setTimeZone(DateUtils.UTC_TIME_ZONE);
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isProxyConnector((String)propertyName)) {
            this.initConfigVariables();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    public Set<String> gatherSnapshotVersions(ManagedRepositoryContent managedRepository, VersionedReference reference) throws LayoutException, IOException, ContentNotFoundException {
        Set<String> foundVersions = managedRepository.getVersions(reference);
        Set<String> proxiedRepoIds = this.proxies.get(managedRepository.getId());
        if (CollectionUtils.isNotEmpty(proxiedRepoIds)) {
            String baseVersion = VersionUtil.getBaseVersion((String)reference.getVersion());
            baseVersion = baseVersion.substring(0, baseVersion.indexOf("SNAPSHOT") - 1);
            for (String proxyId : proxiedRepoIds) {
                SnapshotVersion snapshot;
                ArchivaRepositoryMetadata proxyMetadata = this.readProxyMetadata(managedRepository, reference, proxyId);
                if (proxyMetadata == null || (snapshot = proxyMetadata.getSnapshotVersion()) == null) continue;
                String timestamp = snapshot.getTimestamp();
                int buildNumber = snapshot.getBuildNumber();
                if (!StringUtils.isNotBlank((String)timestamp) || buildNumber <= 0) continue;
                foundVersions.add(baseVersion + "-" + timestamp + "-" + buildNumber);
            }
        }
        return foundVersions;
    }

    public VersionedReference toVersionedReference(String path) throws RepositoryMetadataException {
        if (!path.endsWith("/maven-metadata.xml")) {
            throw new RepositoryMetadataException("Cannot convert to versioned reference, not a metadata file. ");
        }
        VersionedReference reference = new VersionedReference();
        String normalizedPath = StringUtils.replace((String)path, (String)"\\", (String)"/");
        String[] pathParts = StringUtils.split((String)normalizedPath, (char)'/');
        int versionOffset = pathParts.length - 2;
        int artifactIdOffset = versionOffset - 1;
        int groupIdEnd = artifactIdOffset - 1;
        reference.setVersion(pathParts[versionOffset]);
        if (!this.hasNumberAnywhere(reference.getVersion())) {
            throw new RepositoryMetadataException("Not a versioned reference, as version id on path has no number in it.");
        }
        reference.setArtifactId(pathParts[artifactIdOffset]);
        StringBuilder gid = new StringBuilder();
        for (int i = 0; i <= groupIdEnd; ++i) {
            if (i > 0) {
                gid.append(".");
            }
            gid.append(pathParts[i]);
        }
        reference.setGroupId(gid.toString());
        return reference;
    }

    private boolean hasNumberAnywhere(String version) {
        return StringUtils.indexOfAny((String)version, (char[])NUMS) != -1;
    }

    public ProjectReference toProjectReference(String path) throws RepositoryMetadataException {
        if (!path.endsWith("/maven-metadata.xml")) {
            throw new RepositoryMetadataException("Cannot convert to versioned reference, not a metadata file. ");
        }
        ProjectReference reference = new ProjectReference();
        String normalizedPath = StringUtils.replace((String)path, (String)"\\", (String)"/");
        String[] pathParts = StringUtils.split((String)normalizedPath, (char)'/');
        int artifactIdOffset = pathParts.length - 2;
        int groupIdEnd = artifactIdOffset - 1;
        reference.setArtifactId(pathParts[artifactIdOffset]);
        StringBuilder gid = new StringBuilder();
        for (int i = 0; i <= groupIdEnd; ++i) {
            if (i > 0) {
                gid.append(".");
            }
            gid.append(pathParts[i]);
        }
        reference.setGroupId(gid.toString());
        return reference;
    }

    public String toPath(ProjectReference reference) {
        StringBuilder path = new StringBuilder();
        path.append(this.formatAsDirectory(reference.getGroupId())).append('/');
        path.append(reference.getArtifactId()).append('/');
        path.append(MAVEN_METADATA);
        return path.toString();
    }

    public String toPath(VersionedReference reference) {
        StringBuilder path = new StringBuilder();
        path.append(this.formatAsDirectory(reference.getGroupId())).append('/');
        path.append(reference.getArtifactId()).append('/');
        if (reference.getVersion() != null) {
            path.append(VersionUtil.getBaseVersion((String)reference.getVersion())).append('/');
        }
        path.append(MAVEN_METADATA);
        return path.toString();
    }

    private String formatAsDirectory(String directory) {
        return directory.replace('.', '/');
    }

    public String getRepositorySpecificName(RemoteRepositoryContent repository, String path) {
        return this.getRepositorySpecificName(repository.getId(), path);
    }

    public String getRepositorySpecificName(String proxyId, String path) {
        StringBuilder ret = new StringBuilder();
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            ret.append(path.substring(0, idx + 1));
        }
        ret.append("maven-metadata-").append(proxyId).append(".xml");
        return ret.toString();
    }

    @PostConstruct
    public void initialize() {
        this.artifactPatterns = new ArrayList<String>();
        this.proxies = new HashMap<String, Set<String>>();
        this.initConfigVariables();
        this.configuration.addChangeListener((RegistryListener)this);
    }

    public ArchivaRepositoryMetadata readProxyMetadata(ManagedRepositoryContent managedRepository, ProjectReference reference, String proxyId) {
        String metadataPath = this.getRepositorySpecificName(proxyId, this.toPath(reference));
        File metadataFile = new File(managedRepository.getRepoRoot(), metadataPath);
        if (!metadataFile.exists() || !metadataFile.isFile()) {
            return null;
        }
        try {
            return MavenMetadataReader.read((File)metadataFile);
        }
        catch (XMLException e) {
            this.log.warn("Unable to read metadata: {}", (Object)metadataFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public ArchivaRepositoryMetadata readProxyMetadata(ManagedRepositoryContent managedRepository, String logicalResource, String proxyId) {
        String metadataPath = this.getRepositorySpecificName(proxyId, logicalResource);
        File metadataFile = new File(managedRepository.getRepoRoot(), metadataPath);
        if (!metadataFile.exists() || !metadataFile.isFile()) {
            return null;
        }
        try {
            return MavenMetadataReader.read((File)metadataFile);
        }
        catch (XMLException e) {
            this.log.warn("Unable to read metadata: {}", (Object)metadataFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public ArchivaRepositoryMetadata readProxyMetadata(ManagedRepositoryContent managedRepository, VersionedReference reference, String proxyId) {
        String metadataPath = this.getRepositorySpecificName(proxyId, this.toPath(reference));
        File metadataFile = new File(managedRepository.getRepoRoot(), metadataPath);
        if (!metadataFile.exists() || !metadataFile.isFile()) {
            return null;
        }
        try {
            return MavenMetadataReader.read((File)metadataFile);
        }
        catch (XMLException e) {
            this.log.warn("Unable to read metadata: {}", (Object)metadataFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    public void updateMetadata(ManagedRepositoryContent managedRepository, String logicalResource) throws RepositoryMetadataException {
        File metadataFile = new File(managedRepository.getRepoRoot(), logicalResource);
        ArchivaRepositoryMetadata metadata = null;
        List<ArchivaRepositoryMetadata> metadatas = this.getMetadatasForManagedRepository(managedRepository, logicalResource);
        for (ArchivaRepositoryMetadata proxiedMetadata : metadatas) {
            if (metadata == null) {
                metadata = proxiedMetadata;
                continue;
            }
            metadata = RepositoryMetadataMerge.merge(metadata, proxiedMetadata);
        }
        if (metadata == null) {
            this.log.debug("No metadata to update for {}", (Object)logicalResource);
            return;
        }
        Set<String> availableVersions = new HashSet<String>();
        List metadataAvailableVersions = metadata.getAvailableVersions();
        if (metadataAvailableVersions != null) {
            availableVersions.addAll(metadataAvailableVersions);
        }
        if ((availableVersions = this.findPossibleVersions(availableVersions, metadataFile.getParentFile())).size() > 0) {
            this.updateMetadataVersions(availableVersions, metadata);
        }
        RepositoryMetadataWriter.write(metadata, metadataFile);
        ChecksummedFile checksum = new ChecksummedFile(metadataFile);
        checksum.fixChecksums(this.algorithms);
    }

    private Set<String> findPossibleVersions(Set<String> versions, File metadataParentDirectory) {
        HashSet<String> result = new HashSet<String>(versions);
        for (File directory : metadataParentDirectory.listFiles()) {
            if (!directory.isDirectory()) continue;
            for (File possiblePom : directory.listFiles()) {
                if (!possiblePom.getName().endsWith(".pom")) continue;
                result.add(directory.getName());
            }
        }
        return result;
    }

    private List<ArchivaRepositoryMetadata> getMetadatasForManagedRepository(ManagedRepositoryContent managedRepository, String logicalResource) {
        Set<String> proxyIds;
        ArrayList<ArchivaRepositoryMetadata> metadatas = new ArrayList<ArchivaRepositoryMetadata>();
        File file = new File(managedRepository.getRepoRoot(), logicalResource);
        if (file.exists()) {
            try {
                ArchivaRepositoryMetadata existingMetadata = MavenMetadataReader.read((File)file);
                if (existingMetadata != null) {
                    metadatas.add(existingMetadata);
                }
            }
            catch (XMLException e) {
                this.log.debug("Could not read metadata at {}. Metadata will be removed.", (Object)file.getAbsolutePath());
                FileUtils.deleteQuietly((File)file);
            }
        }
        if ((proxyIds = this.proxies.get(managedRepository.getId())) != null) {
            for (String proxyId : proxyIds) {
                ArchivaRepositoryMetadata proxyMetadata = this.readProxyMetadata(managedRepository, logicalResource, proxyId);
                if (proxyMetadata == null) continue;
                metadatas.add(proxyMetadata);
            }
        }
        return metadatas;
    }

    public void updateMetadata(ManagedRepositoryContent managedRepository, ProjectReference reference) throws LayoutException, RepositoryMetadataException, IOException, ContentNotFoundException {
        LinkedHashSet allPlugins;
        File metadataFile = new File(managedRepository.getRepoRoot(), this.toPath(reference));
        long lastUpdated = this.getExistingLastUpdated(metadataFile);
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        metadata.setGroupId(reference.getGroupId());
        metadata.setArtifactId(reference.getArtifactId());
        Set<String> allVersions = managedRepository.getVersions(reference);
        if (metadataFile.exists()) {
            try {
                allPlugins = new LinkedHashSet(MavenMetadataReader.read((File)metadataFile).getPlugins());
            }
            catch (XMLException e) {
                throw new RepositoryMetadataException(e.getMessage(), e);
            }
        } else {
            allPlugins = new LinkedHashSet();
        }
        Set<String> proxiedRepoIds = this.proxies.get(managedRepository.getId());
        if (CollectionUtils.isNotEmpty(proxiedRepoIds)) {
            for (String proxyId : proxiedRepoIds) {
                ArchivaRepositoryMetadata proxyMetadata = this.readProxyMetadata(managedRepository, reference, proxyId);
                if (proxyMetadata == null) continue;
                allVersions.addAll(proxyMetadata.getAvailableVersions());
                allPlugins.addAll(proxyMetadata.getPlugins());
                long proxyLastUpdated = this.getLastUpdated(proxyMetadata);
                lastUpdated = Math.max(lastUpdated, proxyLastUpdated);
            }
        }
        if (!allVersions.isEmpty()) {
            this.updateMetadataVersions(allVersions, metadata);
        } else {
            metadata.setPlugins(new ArrayList(allPlugins));
            metadata.setGroupId(metadata.getGroupId() + "." + metadata.getArtifactId());
            metadata.setArtifactId(null);
        }
        if (lastUpdated > 0L) {
            metadata.setLastUpdatedTimestamp(this.toLastUpdatedDate(lastUpdated));
        }
        RepositoryMetadataWriter.write(metadata, metadataFile);
        ChecksummedFile checksum = new ChecksummedFile(metadataFile);
        checksum.fixChecksums(this.algorithms);
    }

    private void updateMetadataVersions(Collection<String> allVersions, ArchivaRepositoryMetadata metadata) {
        ArrayList<String> sortedVersions = new ArrayList<String>(allVersions);
        Collections.sort(sortedVersions, VersionComparator.getInstance());
        ArrayList<String> releasedVersions = new ArrayList<String>();
        ArrayList<String> snapshotVersions = new ArrayList<String>();
        for (String version : sortedVersions) {
            if (VersionUtil.isSnapshot((String)version)) {
                snapshotVersions.add(version);
                continue;
            }
            releasedVersions.add(version);
        }
        Collections.sort(releasedVersions, VersionComparator.getInstance());
        Collections.sort(snapshotVersions, VersionComparator.getInstance());
        String latestVersion = (String)sortedVersions.get(sortedVersions.size() - 1);
        String releaseVersion = null;
        if (CollectionUtils.isNotEmpty(releasedVersions)) {
            releaseVersion = (String)releasedVersions.get(releasedVersions.size() - 1);
        }
        metadata.setAvailableVersions(sortedVersions);
        metadata.setLatestVersion(latestVersion);
        metadata.setReleasedVersion(releaseVersion);
    }

    private Date toLastUpdatedDate(long lastUpdated) {
        Calendar cal = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
        cal.setTimeInMillis(lastUpdated);
        return cal.getTime();
    }

    private long toLastUpdatedLong(String timestampString) {
        try {
            Date date = this.lastUpdatedFormat.parse(timestampString);
            Calendar cal = Calendar.getInstance(DateUtils.UTC_TIME_ZONE);
            cal.setTime(date);
            return cal.getTimeInMillis();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    private long getLastUpdated(ArchivaRepositoryMetadata metadata) {
        if (metadata == null) {
            return 0L;
        }
        try {
            String lastUpdated = metadata.getLastUpdated();
            if (StringUtils.isBlank((String)lastUpdated)) {
                return 0L;
            }
            Date lastUpdatedDate = this.lastUpdatedFormat.parse(lastUpdated);
            return lastUpdatedDate.getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    private long getExistingLastUpdated(File metadataFile) {
        if (!metadataFile.exists()) {
            return 0L;
        }
        try {
            ArchivaRepositoryMetadata metadata = MavenMetadataReader.read((File)metadataFile);
            return this.getLastUpdated(metadata);
        }
        catch (XMLException e) {
            return 0L;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateMetadata(ManagedRepositoryContent managedRepository, VersionedReference reference) throws LayoutException, RepositoryMetadataException, IOException, ContentNotFoundException {
        File metadataFile = new File(managedRepository.getRepoRoot(), this.toPath(reference));
        long lastUpdated = this.getExistingLastUpdated(metadataFile);
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        metadata.setGroupId(reference.getGroupId());
        metadata.setArtifactId(reference.getArtifactId());
        if (VersionUtil.isSnapshot((String)reference.getVersion())) {
            metadata.setVersion(VersionUtil.getBaseVersion((String)reference.getVersion()));
            Set<String> snapshotVersions = this.gatherSnapshotVersions(managedRepository, reference);
            if (snapshotVersions.isEmpty()) {
                throw new ContentNotFoundException("No snapshot versions found on reference [" + VersionedReference.toKey((VersionedReference)reference) + "].");
            }
            ArrayList<String> sortedVersions = new ArrayList<String>();
            sortedVersions.addAll(snapshotVersions);
            Collections.sort(sortedVersions, new VersionComparator());
            String latestVersion = (String)sortedVersions.get(sortedVersions.size() - 1);
            if (VersionUtil.isUniqueSnapshot((String)latestVersion)) {
                Matcher m = VersionUtil.UNIQUE_SNAPSHOT_PATTERN.matcher(latestVersion);
                if (m.matches()) {
                    metadata.setSnapshotVersion(new SnapshotVersion());
                    int buildNumber = NumberUtils.toInt((String)m.group(3), (int)-1);
                    metadata.getSnapshotVersion().setBuildNumber(buildNumber);
                    Matcher mtimestamp = VersionUtil.TIMESTAMP_PATTERN.matcher(m.group(2));
                    if (mtimestamp.matches()) {
                        String tsDate = mtimestamp.group(1);
                        String tsTime = mtimestamp.group(2);
                        long snapshotLastUpdated = this.toLastUpdatedLong(tsDate + tsTime);
                        lastUpdated = Math.max(lastUpdated, snapshotLastUpdated);
                        metadata.getSnapshotVersion().setTimestamp(m.group(2));
                    }
                }
            } else {
                if (!VersionUtil.isGenericSnapshot((String)latestVersion)) throw new RepositoryMetadataException("Unable to process snapshot version <" + latestVersion + "> reference <" + reference + ">");
                metadata.setSnapshotVersion(new SnapshotVersion());
            }
        } else {
            metadata.setVersion(reference.getVersion());
        }
        if (lastUpdated > 0L) {
            metadata.setLastUpdatedTimestamp(this.toLastUpdatedDate(lastUpdated));
        }
        RepositoryMetadataWriter.write(metadata, metadataFile);
        ChecksummedFile checksum = new ChecksummedFile(metadataFile);
        checksum.fixChecksums(this.algorithms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigVariables() {
        Object object = this.artifactPatterns;
        synchronized (object) {
            this.artifactPatterns.clear();
            this.artifactPatterns.addAll(this.filetypes.getFileTypePatterns("artifacts"));
        }
        object = this.proxies;
        synchronized (object) {
            this.proxies.clear();
            List proxyConfigs = this.configuration.getConfiguration().getProxyConnectors();
            for (ProxyConnectorConfiguration proxyConfig : proxyConfigs) {
                String key = proxyConfig.getSourceRepoId();
                Set<String> remoteRepoIds = this.proxies.get(key);
                if (remoteRepoIds == null) {
                    remoteRepoIds = new HashSet<String>();
                }
                remoteRepoIds.add(proxyConfig.getTargetRepoId());
                this.proxies.put(key, remoteRepoIds);
            }
        }
    }

    public ArtifactReference getFirstArtifact(ManagedRepositoryContent managedRepository, VersionedReference reference) throws LayoutException, IOException {
        File repoDir;
        String path = this.toPath(reference);
        int idx = path.lastIndexOf(47);
        if (idx > 0) {
            path = path.substring(0, idx);
        }
        if (!(repoDir = new File(managedRepository.getRepoRoot(), path)).exists()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-existant directory: " + repoDir.getAbsolutePath());
        }
        if (!repoDir.isDirectory()) {
            throw new IOException("Unable to gather the list of snapshot versions on a non-directory: " + repoDir.getAbsolutePath());
        }
        File[] repoFiles = repoDir.listFiles();
        for (int i = 0; i < repoFiles.length; ++i) {
            String relativePath;
            if (repoFiles[i].isDirectory() || !this.filetypes.matchesArtifactPattern(relativePath = PathUtil.getRelative((String)managedRepository.getRepoRoot(), (File)repoFiles[i]))) continue;
            ArtifactReference artifact = managedRepository.toArtifactReference(relativePath);
            return artifact;
        }
        return null;
    }

    public ArchivaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArchivaConfiguration configuration) {
        this.configuration = configuration;
    }

    public FileTypes getFiletypes() {
        return this.filetypes;
    }

    public void setFiletypes(FileTypes filetypes) {
        this.filetypes = filetypes;
    }
}

