/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.repository.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.model.ArchivaModelCloner;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.model.Plugin;
import org.apache.archiva.model.SnapshotVersion;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.commons.lang.StringUtils;

public class RepositoryMetadataMerge {
    public static ArchivaRepositoryMetadata merge(ArchivaRepositoryMetadata mainMetadata, ArchivaRepositoryMetadata sourceMetadata) throws RepositoryMetadataException {
        if (mainMetadata == null) {
            throw new RepositoryMetadataException("Cannot merge a null main project.");
        }
        if (sourceMetadata == null) {
            throw new RepositoryMetadataException("Cannot copy to a null parent project.");
        }
        ArchivaRepositoryMetadata merged = new ArchivaRepositoryMetadata();
        merged.setGroupId(RepositoryMetadataMerge.merge(mainMetadata.getGroupId(), sourceMetadata.getGroupId()));
        merged.setArtifactId(RepositoryMetadataMerge.merge(mainMetadata.getArtifactId(), sourceMetadata.getArtifactId()));
        merged.setVersion(RepositoryMetadataMerge.merge(mainMetadata.getVersion(), sourceMetadata.getVersion()));
        merged.setReleasedVersion(RepositoryMetadataMerge.merge(mainMetadata.getReleasedVersion(), sourceMetadata.getReleasedVersion()));
        merged.setSnapshotVersion(RepositoryMetadataMerge.merge(mainMetadata.getSnapshotVersion(), sourceMetadata.getSnapshotVersion()));
        merged.setAvailableVersions(RepositoryMetadataMerge.mergeAvailableVersions(mainMetadata.getAvailableVersions(), sourceMetadata.getAvailableVersions()));
        merged.setPlugins(RepositoryMetadataMerge.mergePlugins(mainMetadata.getPlugins(), sourceMetadata.getPlugins()));
        long lastUpdated = RepositoryMetadataMerge.mergeTimestamp(mainMetadata.getLastUpdated(), sourceMetadata.getLastUpdated());
        if (lastUpdated > -1L) {
            merged.setLastUpdated(Long.toString(lastUpdated));
        }
        return merged;
    }

    private static boolean empty(String val) {
        if (val == null) {
            return true;
        }
        return val.trim().length() <= 0;
    }

    private static long mergeTimestamp(String mainTimestamp, String sourceTimestamp) {
        if (sourceTimestamp == null && mainTimestamp != null) {
            return RepositoryMetadataMerge.convertTimestampToLong(mainTimestamp);
        }
        if (mainTimestamp == null && sourceTimestamp != null) {
            return RepositoryMetadataMerge.convertTimestampToLong(sourceTimestamp);
        }
        if (sourceTimestamp == null && mainTimestamp == null) {
            return -1L;
        }
        return RepositoryMetadataMerge.mergeTimestamp(RepositoryMetadataMerge.convertTimestampToLong(mainTimestamp), RepositoryMetadataMerge.convertTimestampToLong(sourceTimestamp));
    }

    private static long mergeTimestamp(long mainTimestamp, long sourceTimestamp) {
        return Math.max(mainTimestamp, sourceTimestamp);
    }

    private static SnapshotVersion merge(SnapshotVersion mainSnapshotVersion, SnapshotVersion sourceSnapshotVersion) {
        long sourceSnapshotLastUpdated;
        if (sourceSnapshotVersion == null) {
            return mainSnapshotVersion;
        }
        if (mainSnapshotVersion == null) {
            return ArchivaModelCloner.clone((SnapshotVersion)sourceSnapshotVersion);
        }
        SnapshotVersion merged = new SnapshotVersion();
        long mainSnapshotLastUpdated = RepositoryMetadataMerge.convertTimestampToLong(mainSnapshotVersion.getTimestamp());
        long lastUpdated = RepositoryMetadataMerge.mergeTimestamp(mainSnapshotLastUpdated, sourceSnapshotLastUpdated = RepositoryMetadataMerge.convertTimestampToLong(sourceSnapshotVersion.getTimestamp()));
        if (lastUpdated == mainSnapshotLastUpdated) {
            merged.setTimestamp(mainSnapshotVersion.getTimestamp());
            merged.setBuildNumber(mainSnapshotVersion.getBuildNumber());
        } else {
            merged.setTimestamp(sourceSnapshotVersion.getTimestamp());
            merged.setBuildNumber(sourceSnapshotVersion.getBuildNumber());
        }
        return merged;
    }

    private static long convertTimestampToLong(String timestamp) {
        if (timestamp == null) {
            return -1L;
        }
        return RepositoryMetadataMerge.getLongFromTimestampSafely(StringUtils.replace((String)timestamp, (String)".", (String)""));
    }

    private static long getLongFromTimestampSafely(String timestampString) {
        try {
            return Long.parseLong(timestampString);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static String merge(String main, String source) {
        if (RepositoryMetadataMerge.empty(main) && !RepositoryMetadataMerge.empty(source)) {
            return source;
        }
        return main;
    }

    private static List<Plugin> mergePlugins(List<Plugin> mainPlugins, List<Plugin> sourcePlugins) {
        if (sourcePlugins == null) {
            return mainPlugins;
        }
        if (mainPlugins == null) {
            return RepositoryMetadataMerge.clonePlugins(sourcePlugins);
        }
        List<Plugin> merged = RepositoryMetadataMerge.clonePlugins(mainPlugins);
        for (Plugin plugin : sourcePlugins) {
            if (merged.contains(plugin)) continue;
            merged.add(plugin);
        }
        return merged;
    }

    private static List<Plugin> clonePlugins(List<Plugin> plugins) {
        if (plugins == null) {
            return null;
        }
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            Plugin clonedPlugin = new Plugin();
            clonedPlugin.setArtifactId(plugin.getArtifactId());
            clonedPlugin.setName(plugin.getName());
            clonedPlugin.setPrefix(plugin.getPrefix());
            result.add(plugin);
        }
        return result;
    }

    private static List<String> mergeAvailableVersions(List<String> mainAvailableVersions, List<String> sourceAvailableVersions) {
        if (sourceAvailableVersions == null) {
            return mainAvailableVersions;
        }
        if (mainAvailableVersions == null) {
            return ArchivaModelCloner.cloneAvailableVersions(sourceAvailableVersions);
        }
        List merged = ArchivaModelCloner.cloneAvailableVersions(mainAvailableVersions);
        for (String sourceVersion : sourceAvailableVersions) {
            if (merged.contains(sourceVersion)) continue;
            merged.add(sourceVersion);
        }
        return merged;
    }
}

