/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.crawler;

import edu.uci.ics.crawler4j.crawler.Page;
import edu.uci.ics.crawler4j.crawler.WebCrawler;
import edu.uci.ics.crawler4j.url.WebURL;
import java.util.regex.Pattern;
import org.apache.any23.plugin.crawler.SharedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebCrawler
extends WebCrawler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebCrawler.class);
    private final SharedData sharedData = SharedData.getInstance();
    private final Pattern pattern = this.sharedData.getPattern();

    public boolean shouldVisit(WebURL url) {
        if (url.getURL() == null) {
            return false;
        }
        String href = url.getURL().toLowerCase();
        if (!href.startsWith(this.sharedData.getSeed())) {
            return false;
        }
        return this.pattern == null || !this.pattern.matcher(href).matches();
    }

    public void visit(Page page) {
        logger.trace("Visiting page: " + page.getWebURL().getURL());
        this.sharedData.notifyPage(page);
    }
}

