/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import com.beust.jcommander.Parameters;
import java.util.Arrays;
import java.util.Objects;
import org.apache.any23.Any23OnlineTestBase;
import org.apache.any23.cli.Tool;
import org.apache.any23.cli.ToolRunner;
import org.junit.Assert;

public abstract class ToolTestBase
extends Any23OnlineTestBase {
    public static final String TOOL_RUN_METHOD = "run";
    private final Class<? extends Tool> toolClazz;

    protected ToolTestBase(Class<? extends Tool> tool) {
        this.toolClazz = Objects.requireNonNull(tool, "Tool class cannot be null.");
    }

    protected int runTool(String ... args) throws Exception {
        String commandName = this.toolClazz.getAnnotation(Parameters.class).commandNames()[0];
        String[] enhancedArgs = new String[args.length + 1];
        enhancedArgs[0] = commandName;
        System.arraycopy(args, 0, enhancedArgs, 1, args.length);
        return new ToolRunner().execute(true, enhancedArgs);
    }

    protected int runTool(String args) throws Exception {
        return this.runTool(args.split(" "));
    }

    protected void runToolCheckExit0(String ... args) throws Exception {
        Assert.assertEquals((String)String.format("Unexpected exit code for tool [%s] invoked with %s", this.toolClazz.getSimpleName(), Arrays.asList(args)), (long)0L, (long)this.runTool(args));
    }
}

